import java.util.*;

/**
 * A class to hold and sort a collection of Antiques.
 * 
 * @author Kingsley Sage 
 * @version 1.0
 */
public class AntiqueShop
{
    private ArrayList<Antique> allAntiques;

    public AntiqueShop()
    {
        allAntiques = new ArrayList<Antique>();
        allAntiques.add(new Antique("ming vase",5000,1400));
        allAntiques.add(new Antique("painting1",10000,1950));
        allAntiques.add(new Antique("harrison watch",8000,1750));
        allAntiques.add(new Antique("sketchbook",200,1978));
    }

    public void showAllAntiques()
    {
        for (Antique a:allAntiques)
        {
            a.showDetails();
        }
    }

    public void sortAntiques()
    {
        Collections.sort(allAntiques);
    }

    public void reverseSortAntiques()
    {
        Collections.sort(allAntiques,Collections.reverseOrder());

    }

    public void sortByAgeCreated()
    {
        Collections.sort(allAntiques, new YearCreatedComparator());
    }
}

