import java.util.*;

/**
 * Examples of using iterators with ArrayList,
 * HashMap and HashSet.
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class IterationExample
{
    private ArrayList<String> myList;
    private HashMap<String,String> myMap;
    private HashSet<String> mySet;

    public IterationExample()
    {
        myList = new ArrayList<String>();
        myMap = new HashMap<String,String>();
        mySet = new HashSet<String>();
    }

    public void listExample()
    {
        myList.add("egg");
        myList.add("potato");
        myList.add("beans");

        // Using a for loop
        for (int i=0; i<myList.size(); i++)
        {
            System.out.println(myList.get(i));
        }

        // Using a for each style loop
        for (String s:myList)
        {
            System.out.println(s);
        }   

        // Using an iterator
        Iterator it = myList.iterator();
        while (it.hasNext())
        {
            String s = (String) it.next();
            System.out.println(s);
        }
    }
    
    public void mapExample()
    {
        myMap.put("John Smith","pilot");
        myMap.put("Jenny Howell","artist");
        myMap.put("Neville Jones","writer");
        
        // Using an iterator - fetching pairs
        Iterator it1 = myMap.entrySet().iterator();
        while (it1.hasNext())
        {
            Map.Entry pair = (Map.Entry) it1.next();
            String k = (String) pair.getKey();
            String v = (String) pair.getValue();
            System.out.println(k + ", " + v);
        }
        
        // Using an iterator over the keySet()
        Iterator it2 = myMap.keySet().iterator();
        while (it2.hasNext())
        {
            String k = (String) it2.next();
            String v = myMap.get(k);
            System.out.println(k + ", " + v);
        }
    }
    
    public void setExample()
    {
        mySet.add("Kirk");
        mySet.add("Spock");
        mySet.add("Scotty");
        
        // Using an iterator
        Iterator it = mySet.iterator();        
        while (it.hasNext())
        {
            String s = (String) it.next();
            System.out.println(s);
        }
    }
}