import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * An example incorporating an ActionListener
 * for a JButton press
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class HelloWorld3 implements Runnable
{
    public void run()
    {
        // First create the JFrame window
        JFrame f = new JFrame("Our first Swing application");
        // Determine what happens when the window is closed
        f.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        // Fetch a reference to the JFrame's contentPane
        Container pane = f.getContentPane();
        // Create a JPanel
        JPanel p = new JPanel();
        // Create a button
        JButton b = new JButton("Press me to quit!");
        // Create a place where we can put some text
        JLabel label1 = new JLabel("Hello World");
        // Add the button and the label to the panel
        p.add(label1);
        
        b.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent e)
                {
                    label1.setText("Well clicked!");
                }
            }
        );

        // Add the button and the label to the panel
        p.add(label1);
        p.add(b);
        // Add the panel to the frame
        f.add(p);
        // Pack the frame ready for display
        f.pack();
        // Make the frame visible
        f.setVisible(true);
    }

    public static void main(String[] args)
    {
        // Create an instance of this class
        HelloWorld3 hw = new HelloWorld3();
        // Schedule the application to run
        SwingUtilities.invokeLater(hw);
    }
}
