import java.awt.*;
import javax.swing.*;
import javax.swing.border.Border;

/**
 * An example of a BorderLayout in action.
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class BorderLayoutExample implements Runnable
{
    public void run()
    {
        // First create the JFrame window
        JFrame f = new JFrame("BorderLayoutExample");
        // Determine what happens when the window is closed
        f.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        // Fetch a reference to the JFrame's contentPane
        Container pane = f.getContentPane();
        // Create a JPanel organised using BorderLayout
        JPanel p = new JPanel(new BorderLayout());
        // Add a label to the centre panel
        JLabel l1 = new JLabel("The Centre",
                    SwingConstants.CENTER);
        l1.setPreferredSize(new Dimension(100,100));
        p.add(l1,BorderLayout.CENTER);
        // Add some buttons
        JButton b1 = new JButton("North");
        JButton b2 = new JButton("South");
        JButton b3 = new JButton("East");
        JButton b4 = new JButton("West");
        p.add(b1,BorderLayout.NORTH);
        p.add(b2,BorderLayout.SOUTH);
        p.add(b3,BorderLayout.EAST);
        p.add(b4,BorderLayout.WEST);
        // Add the panel to the frame
        f.add(p);
        // Pack the frame ready for display
        f.pack();
        // Make the frame visible
        f.setVisible(true);
    }
    
    public static void main(String[] args)
    {
        // Create an instance of this class
        BorderLayoutExample b = new BorderLayoutExample();
        // Schedule the application to run
        SwingUtilities.invokeLater(b);
    }
}
