import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * An example of using text areas
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class TextExamples implements Runnable
{
    public void run()
    {
        // First create the JFrame window
        JFrame f = new JFrame("Some text examples");
        // Determine what happens when the window is closed
        f.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        // Fetch a reference to the JFrame's contentPane
        Container pane = f.getContentPane();
        // Create a JPanel
        JPanel p = new JPanel();
        // Create a JTextField with 20 columns
        JTextField t1 = new JTextField(20);
        t1.addActionListener((event) -> textAction1(f,t1.getText()));
        // Create a JTextArea with 20 rows and 20 columns
        JTextArea t2 = new JTextArea(5,20);
        JScrollPane scrollPane = new JScrollPane(t2);
        scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        t2.setEditable(true); // true by default
        t2.setText("Some text \non several lines");
        // Add to the panel
        p.add(t1);
        // Note we add the scrollPane, not t2 to the panel
        p.add(scrollPane);
        // Add the panel to the frame
        f.add(p);
        // Pack the frame ready for display
        f.pack();
        // Make the frame visible
        f.setVisible(true);
    }

    public void textAction1(JFrame f, String text)
    {
        JOptionPane.showMessageDialog(f,text);
    }
    public static void main(String[] args)
    {
        // Create an instance of this class
        TextExamples t = new TextExamples();
        // Schedule the application to run
        SwingUtilities.invokeLater(t);
    }
}
