import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Some examples of using ImageIcon
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class UsingImages implements Runnable
{
    public void run()
    {
        // First create the JFrame window
        JFrame f = new JFrame("Some text examples");
        // Determine what happens when the window is closed
        f.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        // Fetch a reference to the JFrame's contentPane
        Container pane = f.getContentPane();
        // Create a JPanel
        JPanel p = new JPanel();
        // Create an image for the button
        String path1 = "/resources/image1.png";
        java.net.URL imgURL1 =
             UsingImages.class.getResource(path1);
        ImageIcon icon1 = new ImageIcon(imgURL1);
        // Create the button
        JButton b1 = new JButton("",icon1);
        // Add an ActionListener for completeness
        b1.addActionListener((event) -> showMessage(f));
        // Add to the panel
        p.add(b1);
        
        // Create an image for the JLabel
        String path2 = "/resources/image2.png";
        java.net.URL imgURL2 =
             UsingImages.class.getResource(path2);
        ImageIcon icon2 = new ImageIcon(imgURL2);
        JLabel k1 = new JLabel("",icon2,JLabel.CENTER);
        p.add(k1);

        // Add the panel to the frame
        f.add(p);
        // Pack the frame ready for display
        f.pack();
        // Make the frame visible
        f.setVisible(true);
    }

    public void showMessage(JFrame f)
    {
        JOptionPane.showMessageDialog(f,"It's a nice button");
    }
    public static void main(String[] args)
    {
        // Create an instance of this class
        UsingImages i = new UsingImages();
        // Schedule the application to run
        SwingUtilities.invokeLater(i);
    }
}
