import java.util.*;

/**
 * A Customer for the GoodLifeFoods shop.
 * 
 * @author  Kingsley Sage
 * @version 1.0
 */
public class Customer
{
    private String lastname;
    private String firstname;
    private String address;
    private Order myOrder;
    
    /**
     * Constructor.
     * @param lastname as a String.
     * @param firstname as a String.
     * @param address as a String.
     */
    public Customer(String lastname, String firstname, String address)
    {
        this.lastname = lastname;
        this.firstname = firstname;
        this.address = address;
        // Need to devise a means of generating
        // unique reference numbers.
        // This is provided by a static factory
        // method in the GoodLifeFoods class.
        String ur = GoodLifeFoods.genUniqueReference();
        myOrder = new Order(ur);
    }
    
    /**
     * Add an item to the customers order.
     * @param an Item i.
     */
    public void addItemToOrder(Item i)
    {
        myOrder.getAllItems().add(i);
    }
    
    /**
     * Delete an item from the customer order.
     * @param int of the index in the order ArrayList.
     */
    public void deleteItemFromOrder(int i)
    // Very simple - no error checking - just delete using ArrayList index
    {
        myOrder.getAllItems().remove(i);
    }
    
    /**
     * Displays details about this order.
     */
    public void displayDetailsOfOrder()
    {
        System.out.println("Name: " + firstname + " " + lastname);
        System.out.println("Address: " + address);
    }
    
    /** 
     * Accessor method.
     * @return String customers last name.
     */
    public String getLastName()
    {
        return lastname;
    }
  
    /** 
     * Accessor method.
     * @return reference to Order object.
     */
    public Order getOrder()
    {
        return myOrder;
    }
    
    /**
     * Calculates the total cost of this order
     * including delivery charges.
     * @return cost in pounds as a double.
     */
    public double calculateTotalCost()
    {
        return myOrder.calculateTotalCost();
    }
    
    /**
     * Summarises the customers order.
     */
    public void summariseOrder()
    {
        System.out.println("Order for " + firstname +
                           " " + lastname);
        myOrder.summarise();
    }
    

}
