
/**
 * A fruit available for purchase.
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class Fruit extends Item
{
    private int quantity;
    
    /**
     * Constructor.
     * @param name of the Fruit as a String.
     * @param unit cost of the Fruit in pounds as a double.
     * @param quantity of this Fruit required as an int.
     */
    public Fruit(String name, double unitCost, int quantity)
    {
        super(name, unitCost);
        this.quantity = quantity;
    }
    
    /**
     * Calculates the cost of the fruit based on unit
     * cost and quantity required.
     * @return cost as a double.
     */
    public double calculateCost()
    {
        return unitCost * quantity;
    }
    
    /**
     * Describes the fruit item.
     */
    public void describeItem()
    {
        System.out.println(name + ", unit cost: £" + 
                           String.format("%.2f",unitCost) + 
                           ", quantity: " + quantity);
    }
}
