
/**
 * A HealthyCake product that can be purchased.
 * 
 * @author Kingsley Sage 
 * @version 1.0
 */
public class HealthyCake extends Item
{
    private String msg;
    
    /**
     * Constructor.
     * @param name of this HealthyCake as a String.
     * @param unit cost of this HealthyCake in pounds as a double.
     * @param the message to be placed on this HealthyCake as a String.
     */
    public HealthyCake(String name, double unitCost, String msg)
    {
        super(name, unitCost);
        this.msg = msg;
    }
    
    /**
     * Returns the cost of this cake.
     * @return cost in pounds as a double.
     */
    public double calculateCost()
    {
        return unitCost;
    }
    
    /**
     * Describes this cake product.
     */
    public void describeItem()
    {
        System.out.println(name + ", unit cost: £" + 
                           String.format("%.2f",unitCost) + 
                           ", message: " + msg);
    }
}
