
/**
 * A vegtable product that can be purchased.
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class Vegetable extends Item
{
    private double weight;

    /**
     * Constructor.
     */
    public Vegetable(String name, double unitCost, double weight)
    {
        super(name, unitCost);
        this.weight = weight;
    }
    /**
     * Calculates the cost of the vegtable based on unit
     * cost and quantity required.
     * @return cost as a double.
     */
    public double calculateCost()
    {
        return unitCost * weight;
    }

    /**
     * Describes this vegtable product.
     */
    public void describeItem()
    {
        System.out.println(name + ", unit cost: £" + 
                           String.format("%.2f",unitCost) + 
                           ", weight: " + weight + "Kg");
    }
}
