function fig2_1
%% To generate a cobweb plot 
% This function is to generate the cobweb plot associated with
% the orbits x_n+1=f(x_n), figure 2.1 in our Chaos book
% Fowler & McGuinness

a=0; b=1; x0=0.02; N=6;

% generate 100 linearly spaced values on (a,b)
xx=linspace(a,b,100);  
% use to plot the function y=f(x)
y=f(xx);

% turn hold on to gather up all plots in one figure

figure(1)
clf('reset')

hold on;
plot(xx,y,'-k', 'linewidth',3); % plot the function
plot(xx,xx,'-r', 'linewidth',2); % plot the straight line

x=zeros(1,N+2);

x(1)=x0; % plot orbit starting at x0

x(2)=f(x(1));
plot([x0,x0],[0,x(2)], '-k','linewidth',2);
plot([x0,x(2)],[x(2),x(2)],'-k', 'linewidth',2);

for i=2:N
    x(i+1)=f(x(i));  % iterate the map once
    plot([x(i),x(i)],[x(i),x(i+1)], '-k','linewidth',2);
    plot([x(i),x(i+1)],[x(i+1),x(i+1)],'-k', 'linewidth',2);
end

hold off;

ax=gca;
defFont=32;
ax.FontSize=defFont; ax.FontName='Times';
xlabel('x_n','FontSize',1.2*defFont); ylabel('x_{n+1}','FontSize',1.2*defFont);
hYLabel = get(gca,'YLabel');
set(hYLabel,'rotation',0,'VerticalAlignment','top')

function yy=f(x)
    lambda=4;
   yy=lambda*x.*(1-x);
end
end
