function fig2_2
%% This m-file generates figure 2.2, a bifurcation or cascade diagram for the Logistic map

% map iteration length for plotted points
N = 500;

% number of iterates to do before plotting points
T = 1000;

% Number of lambda values to use
M = 1000;

% Initial condition
y0 = 0.7;

% Minimum and maximum lambda values to use
lambda_min   = 2.8;
lambda_max   = 4.0;

% Loop initialisation
lambda_delta = (lambda_max - lambda_min)/M;
lambda = lambda_min;

bif_y=zeros(N+1,M);
bif_x=bif_y;

% Bifurcation parameter loop
for m = 1:M

   % Logistic map iteration not plotted
   y = y0;
   for n = 1:T
      y = lambda*y*(1-y);
   end
   
   % Logistic map iteration plotted
   bif_y(1,m) = y;
   bif_x(1,m) = lambda;
   for n = 1:N
      bif_y(n+1,m) = lambda*bif_y(n,m)*(1-bif_y(n,m));
      bif_x(n+1,m) = lambda;
   end

   % Update parameter
   lambda = lambda + lambda_delta;
end

% Plot bifurcation diagram
figure(1); clf('reset');
plot(bif_x, bif_y, 'k.', 'MarkerSize', 1);

hold on;
lam=linspace(3,3.7,50);
unstable=1-1./lam;
plot(lam, unstable, '--k','LineWidth',3)  % plot the unstable fixed point too

ax=gca;
defFont=32;
ax.FontSize=defFont; ax.FontName='Times';
xlabel('\lambda','FontSize',1.3*defFont); ylabel('x','FontSize',1.3*defFont);
hYLabel = get(gca,'YLabel');
set(hYLabel,'rotation',0,'VerticalAlignment','top')


