function fig3_3b
%% Generates the second of figures 3.3
% to generate figure 3.3b in Chaos: an introduction for applied mathematicians
% Mark Mcguinness

tend=10;
mu=0.09; omega=1.0;
ICs=[0.5 0.5; 0 sqrt(mu)];
options=odeset('RelTol',1e-4,'AbsTol',1e-4);

mywidth=4;

fno=1;
figure(fno);
clf('reset')
hold on;

ax=gca;
defFont=36;
ax.FontSize=defFont; ax.FontName='Times';
ax.XTickMode='manual';  
ax.YTickMode='manual';
xlabel('x','FontSize',1.3*defFont); ylabel('y','FontSize',1.3*defFont,'Rotation',0.0);
ax.LineWidth=2.0; ax.Box='off';
ax.YAxisLocation = 'origin';
ax.XAxisLocation = 'origin';

for ii=1:length(ICs(:,1))

    [Tsol,Ysol]=ode45(@MyDE,[0,tend],ICs(ii,:),options);   
    tspan=linspace(0,tend,200);
    Ys =interp1(Tsol,Ysol,tspan)';
    xvals=Ys(1,:); yvals=Ys(2,:);
    
    plot(xvals,yvals,'-k','linewidth',mywidth)
    
    % the arrows are difficult to place correctly in code, so just move
    % them directly in the figure window once this is run:
   
    annotation('arrow',[0.5 0.48],[0.682 0.675],'linewidth',1,'headlength',...
        20,'headwidth',20)  %located at [x_begin, x_end], [y_begin, y_end]
    annotation('arrow',[0.5 0.48],[0.44 0.437],'linewidth',1,'headlength',...
        20,'headwidth',20)

    
end

%====================================

tend=15;

ICs=[ 0.07 0.07];

for ii=1:length(ICs(:,1))

    [Tsol,Ysol]=ode45(@MyDE,[0,tend],ICs(ii,:),options);
    
    
        tspan=linspace(0,tend,200);
        

    Ys =interp1(Tsol,Ysol,tspan)';

    xvals=Ys(1,:); yvals=Ys(2,:);
    
    plot(xvals,yvals,'-k','linewidth',mywidth)

   
    annotation('arrow',[0.5 0.48],[0.505 0.505],'linewidth',1,'headlength',20,'headwidth',20)

    
end



hold off;



function F=MyDE(~,yy)
    
   % eqn 3.9 in the book
    r2 = yy'*yy;  % sum of squares of components of yy
    f1=(mu-r2)*yy(1) -omega*yy(2);
    f2=omega*yy(1)+ (mu-r2)*yy(2); 
    F=[f1; f2];  


end



end