function fig4_3
%% Figure 4.3
% to generate figure 4.3 (a) and (b) in Chaos book 2019
% x'' + V_x=0, with V=-x^2/2 +x^4/4
% Mark McGuinness

% first plot the potential function V(x):

xs=linspace(-1.6,1.6,201);
V=-0.5*xs.*xs + 0.24*xs.^4;
mywidth=3;
defFont=36;

fno=1;
figure(fno);
clf('reset')

plot(xs,V,'-k','linewidth',mywidth)
ax=gca;
ax.FontSize=defFont; ax.FontName='Times';
ax.LineWidth=2.0; ax.Box='off';
ax.XTickMode='manual';  
ax.YTickMode='manual';
ax.YAxisLocation = 'origin';
ax.XAxisLocation = 'origin';

xlabel('x','FontSize',1.3*defFont); ylabel('V','FontSize',1.3*defFont,'Rotation',0.0);

tend=15;

ICs=[1 1; 1 0.4; -1 0.4; 0.01 0.01; -0.01 -0.01]; 

options=odeset('RelTol',1e-8,'AbsTol',1e-8, 'Events',@events);

%plot axis limits:
almt=2;
xminp=-almt; xmaxp=almt; yminp=-almt; ymaxp=almt;

fno=fno+1;
figure(fno);
clf('reset');

hold on;

axis([xminp xmaxp yminp ymaxp]);
ax=gca;
defFont=36;
ax.FontSize=defFont; ax.FontName='Times';
ax.LineWidth=2.0; ax.Box='off';
ax.XTickMode='manual';  
ax.YTickMode='manual';
ax.XTick=[]; ax.YTick=[];
ax.YAxisLocation = 'origin';
ax.XAxisLocation = 'origin';

xlabel('x','FontSize',1.3*defFont); ylabel('x^.  ','FontSize',1.3*defFont,'Rotation',0.0);

for ii=1:length(ICs(:,1))
    [Tsol,Ysol,TE,~,~]=ode45(@MyDE,[0,tend],ICs(ii,:),options);
    %note that TE might be empty. Doesn't always go outside region:
    if isempty(TE)
        tspan=linspace(0,tend,200);
    else
        tspan=linspace(0,TE,200);
    end
    Ys =interp1(Tsol,Ysol,tspan)';

    xvals=Ys(1,:); yvals=Ys(2,:);
    
    plot(xvals,yvals,'-k','linewidth',mywidth)

   % aaand run it backwards in time too:
    [Tsol,Ysol,TE,~,~]=ode45(@MyDE,[0,-tend],ICs(ii,:),options);
    if isempty(TE)
        tspan=linspace(0,-tend,200);
    else
        tspan=linspace(0,TE,200);
    end

    Ys=interp1(Tsol,Ysol,tspan)';

    xvals=Ys(1,:); yvals=Ys(2,:);    
    
    plot(xvals,yvals,'-k','linewidth',mywidth)

    
end

hold off;

function F=MyDE(~,yy)   
    f1=yy(2);
    f2=yy(1)-yy(1)^3;   
    F=[f1; f2];            
end

function [value,isterminal,direction]=events(~,y)
    isterminal=[1;1]; direction=[0;0];
    value=(y-[xmaxp;ymaxp]) .*(y-[xminp;yminp]); %stops if this product is zero
end

end