function fig5_19
%% To iterate the Henon Map, eqn 5.178 
% zoomed in on x=0.57, y=0.16, the saddle
% Produces figure 5.19 in our Chaos book

% Mark McGuinness


alpha=1.328;

xvecsp = linspace(0.45, 0.7, 25);
yvecsp = 0.16*ones(1, length(xvecsp));

yvecsp2 = linspace(0.06, 0.28, 25);
xvecsp2 = 0.57*ones(1, length(yvecsp2));

xvec = [xvecsp, xvecsp2];
yvec = [yvecsp, yvecsp2];
                                           
% plot next lot of iterations

figure(1)
clf('reset')
hold on;
nplot=2000;
for ii=1:nplot
    [xvec,yvec] = HenonMap(xvec,yvec, alpha);
    plot(xvec, yvec,'.r','MarkerSize',10);
    if norm(xvec) > 10.0
        disp(norm(xvec))
        disp('x getting too big')
        disp(ii)
        break  % stop this if it gets too big, which it does
    end
%     display(xvec)
%     display(yvec)
end

    ax=gca;
    axis([0.45  0.7  0.05  0.3]);
    grid off;
    defFont=24;
    ax.FontSize=defFont; ax.FontName='Times';
    ax.XTick=[0.5, 0.6, 0.7];
    ax.YTick=[0.1, 0.2, 0.3];
    ax.LineWidth=2.0;  ax.Box='on';
    xlabel('x','FontSize',2*defFont); ylabel('y','FontSize',2*defFont,'Rotation',0.0);
 
    hold off;

    function [xo, yo] = HenonMap(x,y,alpha)
    % the Henon map. Inputs can be matrices or vectors or scalars
    
    xo=cos(alpha)*x +(x.*x-y)*sin(alpha); 
    yo =x*sin(alpha) + cos(alpha)*(y-x.*x);  

    end
end

