function fig5_4
%% Generates figure 5.4, by iterating the Standard Map
% To iterate the Standard Map, eqn 5.142 in "Chaos"
% Mark McGuinness

K=0.85;

thetavec=linspace(-pi, pi, 17);

Ivec=linspace(0,2*pi,5);
[thetarr, Iarr] = meshgrid(thetavec, Ivec); % creates arrays that mesh the space
                                            % eg thetarr(i,j) and Iarr(i,j)
                                            % are the coords of mesh point
                                            % (i,j)

                                            
% do some iterations without plotting them:

nskip=300;
for ii=1:nskip
   [thetarr,Iarr] = staMap(thetarr,Iarr,K);    %does a bunch of ICs at once
end

% plot next lot of iterations

figure(1)
clf('reset')
hold on;
nplot=300;
for ii=1:nplot
    [thetarr,Iarr] = staMap(thetarr,Iarr,K);
    plot(thetarr,Iarr,'.r','MarkerSize',7);
end

    ax=gca;
    axis image;
    grid off;
    defFont=24;
    ax.FontSize=defFont; ax.FontName='Times';
    ax.XTick=[-pi, 0, 0.999*pi];
    ax.YTick=[0, pi, 2*pi];
    ax.XTickLabel={'-\pi', '0', '\pi'};
    ax.YTickLabel={'0', '\pi', '2 \pi'};
    ax.LineWidth=2.0;  ax.Box='on';

    xlabel('\theta','FontSize',1.3*defFont); ylabel('I','FontSize',1.3*defFont,'Rotation',0.0);
 
    hold off;


    function [thetao, Io] = staMap(theta,I,K)
    % the actual standard map. Inputs can be matrices or vectors or scalars
            
    Io=I + K*sin(theta);
    Io=mod(Io,2*pi);
    thetao=theta + Io;  %note that Io appears on RHS, not I
    thetao=mod(thetao+pi,2*pi)-pi;
    end
end

