function fig5_7
%% Iterate Standard Map for Figure 5.7
% To iterate the Standard Map, eqn 5.142, and produce fig 5.7
% runs in seconds
% Mark McGuinness

K=0.757;

thetavec=linspace(0, 2*pi, 13);

Ivec=linspace(0,2*pi,9);

[thetarr, Iarr] = meshgrid(thetavec, Ivec); % creates arrays that mesh the space
                                            % eg thetarr(i,j) and Iarr(i,j)
                                            % are the coords of mesh point
                                            % (i,j)                                          
% do some iterations without plotting them:

nskip=300;
for ii=1:nskip
   [thetarr,Iarr] = staMap(thetarr,Iarr,K);    %does a bunch of ICs at once
end

% plot next lot of iterations, using cartesian coordinates

figure(1)
clf('reset')

ax1=gca; %save current plot handle as ax1
hold(ax1,'on');

nplot=600;
for ii=1:nplot
    [thetarr,Iarr] = staMap(thetarr,Iarr,K);
    
    plot(ax1,thetarr,Iarr,'.r','MarkerSize',7); %plot cartesian to fig 1

end

    ax=ax1;
    axis(ax,'image');
    grid off;
    defFont=24;
    xlabel('\theta','FontSize',1.3*defFont); ylabel('I','FontSize',1.3*defFont,'Rotation',0.0);
    daspect auto;
    
    ax.FontSize=defFont; ax.FontName='Times';
    ax.XTick=[0, 0.999*2*pi];
    ax.XTickLabel={ '0', '2\pi'};    
    ax.YTick=[0,  2*pi];
    ax.YTickLabel={'0',  '2 \pi'};
    ax.XTickMode='manual';  
    ax.YTickMode='manual';
    ax.LineWidth=2.0;  ax.Box='on';
    hold(ax1,'off');
    
    function [thetao, Io] = staMap(theta,I,K)
    % the actual standard map. Inputs can be matrices or vectors or scalars
     
    Io=I + K*sin(theta);
    Io=mod(Io+pi,4*pi)-pi; % this is to get Io in [-pi,3pi)
    thetao=theta + Io;  %note that Io appears on RHS, not I
    thetao=mod(thetao,2*pi);  % this puts theta in range [0,2pi)
    
    end
end

