function fig6_1a
%% Generates a solution to the delay recruitment, figure 6.1(a)
% When tolerances are set to 1E-08, it takes a few seconds to iterate to
% tend=10, but takes 12 hours to iterate to tend=200, which is the value
% used to generate Fig 6.1 (a)
% Mark McGuinness;

tend=10;

lambda=3.8;
epsilon=0.01;

options=odeset('RelTol',1e-8,'AbsTol',1e-8);

%set up random initial conditions:
nics=10;
itime=linspace(-1,0,nics);

% iix=zeros(nics,1);
% for ii=1:nics 
%     iix(ii)=0.5+0.2*randn;
% end

% here are random values chosen previously, as some random values lead to
% numerical difficulties:
iix=[0.6343; 0.2585; 0.6434; 0.8260; 0.5978; 0.7069; 0.6454; 0.4393;0.5588;0.3425];

soln =dde23(@MyDDE,1,@Histry,[0,tend],options);
    
times=linspace(tend/2,tend,500);
xvals=deval(soln,times);

figure(1)
clf('reset');

plot(times, xvals,'-r','LineWidth',2); 
ax=gca;

grid off;
defFont=24;
ax.FontSize=defFont; ax.FontName='Times';
ax.LineWidth=2.0;  ax.Box='on';
xlabel('t','FontSize',2*defFont); ylabel('x','FontSize',2*defFont,'Rotation',0.0);
 

    function F = MyDDE(~,x,Z)
        % delay recruitment equation

        F=-x + lambda*Z.*(1-Z);
        F=F/epsilon;
    end

    function x = Histry(t)
        x=interp1(itime,iix,t);  %interpolate the values in iix at times itime, to get a value at t
    end
 

end