function fig6_3
%% to generate figure 6.3 in our chaos book 2018. 
% A periodogram power spectrum density of the
% solution to the lorenz equations
% Mark McGuinness

sigma=10; r=28; b=8/3;
 
tend=100;
defFont=36;
ICs=[5 5 10];  %for lorenz equations

options=odeset('RelTol',1e-4,'AbsTol',1e-4);

mywidth=2;

% 
 [Tsol,Ysol]=ode45(@MyDE,[0,tend],ICs,options);
% 


Ys =Ysol;
xvals=Ys(:,1);% zvals=Ys(:,3);

    
fno=1;

figure(fno); % plot x vs time:
clf('reset')

plot(Tsol,xvals,'-k','linewidth',mywidth)

ax=gca;
ax.FontSize=defFont; ax.FontName='Times';
xlabel('t'); ylabel('x','Rotation',0.0);
grid off;
ax.LineWidth=2.0;  ax.Box='on';

% get a power of 2 interpolation of the solution for periodogram:

nts=2^9 ; %512 points, just barely resolves the fastest oscillations
%nts=2^11; % this resolves the oscillations better, but has little impact
%on the periodogram, just shows what is happening in between
tspan=linspace(0,tend,nts);
dt = tspan(2)-tspan(1);
display(dt)
Ys =interp1(Tsol,Ysol,tspan)';
xvals=Ys(1,:); % a row vector
    
fno=fno+1;
figure(fno); % plot x vs time; just checking resolution:
clf('reset')
 
plot(tspan,xvals,'-k','linewidth',mywidth)

ax=gca;
ax.FontSize=defFont; ax.FontName='Times';
xlabel('t'); ylabel('x','Rotation',0.0);
title('resolution check on interpolated x values')
grid off;
ax.LineWidth=2.0;  ax.Box='on';

% now get the periodogram:  w is capital Omega in fact
nvals=length(xvals);

% a one-sided version first:

[pxx,w] = periodogram(xvals,[],nvals); % because xvals is real, matlab does
                                       % a one-sided periodogram, which gets doubled in amplitude 
% and winds up twice the amplitude of the directly coded periodogram;
% effectively adding the negative frequency to the corresponding positive
% frequency. Then the conversion to our amplitude is to multiply pxx by pi.dt 

% now a two-sided periodogram PSD:

[pxx2,w2] = periodogram(xvals,[],nvals,'twosided'); % force a two-sided periodogram, 
% so that the amplitude is not doubled, and conversion to our amplitude is to multiply
% amplitude by 2.pi.dt

pxx(1) = 2*pxx(1); % because I halve pxx later, and other points get 
                   % doubled in magnitude by matlab since it is one-sided, 
                   % but this one is not doubled. (I don't
                   % display the last one, so I don't bother with that one)


%========================================
% check the periodogram result against one done from first principles,
% using eqns 6.17 and 6.18 from our book. Use the Omega values returned by
% the periodogram command

jnumb=1:nvals; % the numbering (j) in the exponent. nvals is max j, the number
                % of terms in the time series.
exponents=jnumb' * w'; % gives [Omega_1, Omega_2..Omega_m; 2*Omega_1, 2*Omega_2, ......nts*Omega_1, ..]
                       % since jnumb' is column vector and w' is a row
                       % vector of Omega_i values wanted

PSum = xvals * exp(1i*exponents);  % xvals is a row vector. The desired sum comes from the 
                                    % resulting dot products of xvals with
                                    % columns of exp(i*exponents).
BookP = dt/nvals*abs(PSum).^2; % this should be a row vector of the P(Omega) values

% plot both BookP and the psds from the periodogram command on same plot:
% they match if I do two-sided as well as 2 pi dt times psd, or one-sided
% and pi dt times the psd as here. 

dw = w(2)-w(1);
display(dw)

fno=fno+1;
figure(fno); % linear plots
clf('reset')
 
plot(w/dt,pi*dt*pxx,'ok','linewidth',mywidth,'MarkerSize',10)  % the one-sided periodogram PSD
                                           % computed by matlab
hold on;
plot(w/dt, BookP', '-r','linewidth',mywidth)  % the direct calculation using the 
                                               % formula in our Chaos Book
                                               
plot(w2/dt, 2*pi*dt*pxx2, '+b','linewidth',mywidth,'MarkerSize',10) % the two-sided periodogram
                                             % PSD computed by matlab

ax=gca;
ax.FontSize=defFont; ax.FontName='Times';
xlim([0 15])
grid off;
ax.XTick=[0, 5, 10, 15];
ax.LineWidth=2.0;  ax.Box='on';
xlabel('\omega'); ylabel('P','Rotation',0.0);


% also look at a higher resolution direct calculation of P:
% don't go beyond omega=15 though, as this is the nyquist frequency
% for time in (0,100) - dt=100/512, f_nyquist =1/(2 dt)= 512/200, omega =
% 2pi f_nyq = 5pi is approx 15.
% the spacing of Omega/dt (which is the actual omega) before was 1/16; so we
% were plotting 256 values before, in range 0-15 radians.
% Hence the spacing of Omega will be dt/16, or 100/512/16.
% try increasing this resolution, but only in the direct calculation: 

oldwsp=w(2)-w(1);
display(oldwsp)

newsp=oldwsp/32;  % the desired new spacing in Omega; 32 times the number of points

maxw = 15*dt;  % the desired max in Omega (giving a max omega of 15)

numws = ceil(maxw/newsp) + 1;  % the number of Omega values we will get

newjns=1:numws;
newws = newsp*newjns;  % row vector, of the new Omega values to use
newwsp=newws(2)-newws(1);
display(newwsp)
display(newws(end)/dt)

exponents=jnumb' * newws; % gives [Omega_1, Omega_2..Omega_m; 2*Omega_1, 2*Omega_2, ...nts*Omega_1, ..]
                       % since jnumb' is column vector, as long as the number of time values;
                       % and w' is a row
                       % vector. m is number of Omegas. 

PSum2 = xvals * exp(1i*exponents);  % xvals is a row vector. The desired sum comes from the 
                                    % resulting dot products of xvals with
                                    % columns of exp(i*exponents).
BookP2 = dt/nvals*abs(PSum2).^2; % this should be a row vector of the new P(Omega) values

%========================================

% find local maxima in BookP2:
pdiffs=diff(BookP2);  %find first differences between powers
ichoose=pdiffs(2:end).* pdiffs(1:end-1) <= 0.0; % look for a change of sign
ichoose=circshift(ichoose,1);  % the 1 values were one to the left of extrema
pselect=BookP2(ichoose);  % select the maxima and minima in BookP2
chooseOmega=newws(ichoose);  % the Omega values corresponding to maxima and minima
[pmax,imax]=sort(pselect,'descend'); % find biggest to smallest powers, index them in imax

disp('first few peaks of periodogram have powers:')
disp(pmax(1:15))
disp('at omega values:')
disp(chooseOmega(imax(1:15))/dt)

fno=fno+1;
figure(fno); % linear plots
clf('reset')
 
plot(w/dt,pi*dt*pxx,'-r','linewidth',mywidth)
hold on;
plot(newws/dt, BookP2', 'ob','linewidth',mywidth)
plot(newws/dt, BookP2', '-b','linewidth',1)

ax=gca;
defFont=36;
ax.FontSize=defFont; ax.FontName='Times';
xlabel('\omega'); ylabel('P','Rotation',0.0);
xlim([0 15])
grid off;
ax.LineWidth=2.0;  ax.Box='on';
hold off;

fno=fno+1;
figure(fno); 
clf('reset')
 
plot(newws/dt, BookP2', '-r','linewidth',mywidth)

ax=gca;
defFont=36;
ax.FontSize=defFont; ax.FontName='Times';
xlabel('\omega'); ylabel('P','Rotation',0.0);
xlim([0 15])
grid off;
ax.LineWidth=2.0;  ax.Box='on';

function F=MyDE(~,yy)
% the Lorenz equations
    x=yy(1);
    y=yy(2);
    z=yy(3);
    f1  = sigma*(y-x);
    f2 = (r-z)*x -y;
    f3 = x*y -b*z;
    F=[f1; f2; f3];
    
 
end


end