function fig6_9
%% This iterates a function system to generate the black spleenwort fractal image.
% This is figure 6.9 in our Chaos book. 
% The ouput image resolution is WIDTHxHEIGHT
% This file uses the random iteration algorithm from Michael Barnsley's
% book called Fractals Everywhere.

% Mark McGuinness


% maximum number of iterations
 Nits = 500000; % this only takes a second or two to complete

% black spleenwort data from Barnsley's book:
a = [0 0.85 0.2 -0.15];
b = [0 0.04 -0.26 0.28 ];
c = [0 -0.04 0.23 0.26];
d = [0.16 0.85 0.22 0.24];
e = [0 0 0 0];
f = [0 1.6 1.6 0.44];
p = [0.01 0.85 0.07 0.07];

% set up so iterate is wi*v+Ti:

w1=[a(1) b(1); c(1) d(1)];
w2=[a(2) b(2); c(2) d(2)];
w3=[a(3) b(3); c(3) d(3)];
w4=[a(4) b(4); c(4) d(4)];
warr = cat(3,w1, w2, w3, w4);

T1 = [e(1); f(1)];
T2 = [e(2); f(2)];
T3 = [e(3); f(3)];
T4 = [e(4); f(4)];
Tarr=cat(3,T1, T2, T3, T4);

% Allocate space for output
vsav = zeros(2,Nits); % will hold x,y coords of iterates, one set per col
v=[0; 0]; %initial point to iterate on

for m = 1:10 %skip the first ten random iterations; save the rest
 v = IFSterate(v,warr,Tarr,p);  %iterate without saving 
end

for m = 1:Nits %save the rest of the  random iterations
 v = IFSterate(v,warr,Tarr,p);  %iterate and save
 vsav(:,m)=v;
end

f=figure(1);
clf('reset')

scatter(vsav(1,:), vsav(2,:),3,'filled' , ...
        'MarkerFaceColor',[0 0.3 0.1],'MarkerFaceAlpha',0.3) 
    
axis([-3 3  -1, 11]);
f.Position=[600 10 600 900];

    function vout=IFSterate(v,warr,Tarr,p)
        %IFSterate iterates the IFS warr*v+Tarr using probability p to
        %select the component of warr and Tarr to use
    choice= rand;  %this is uniform on [0,1)
    if choice <p(1)  % this set of if statements should choose wi with 
                     % probabilities determined by the vector p:
        k=1;
    elseif choice <( p(1)+p(2) )
        k=2;
    elseif choice <( p(1)+p(2)+p(3) )
        k=3;
    else
        k=4;
    end
        vout = warr(:,:,k)*v + Tarr(:,:,k);  %iterate using the kth function
    end

end