function fig2_17
%% The logistic map - bifurcation diagram and iterates of zero
% This m-file iterates zero under the logistic map, and superposes the 
% resulting curves onto the bifurcation diagram.
% The logistic map is here in form 1-mu x^2. The starting point x=0
% provides plots of x vs mu. That is, show the iterates of
% origin for this map. Up to N iterates. The bifurcation diagram is 
% generated by starting with x0=0.7 
% Mark McGuinness


% Number of points to plot (number of mu values)
M = 201;

% number of iterates of zero to show
N=6;

% Minimum and maximum mu values
mumin   = 0;
mumax   = 2;

muvals=linspace(mumin, mumax, M);  %make the mu values a column vector

% compute, for each mu value, N iterates of zero, and prepare to plot each
% iterate as y vs mu. eg the first iterate is just y=1, independent of mu

y=zeros(N,M);  %each row is a different # of iterates of f(0) (vs mu)
y(1,:) = 1;  % the first iterate is simply 1, for all mu values

for nn=2:N
   y(nn,:) = f(muvals, y(nn-1,:));  %generates second and higher iterates of f(0) at mu=muvals (vector)  
end

% plot N iterations after ignoring T iterations:
N = 200;
T = 500;

% Number of points on the bifurcation parameter axis to evaluate
M = 2000;

% Initial condition
y0 = 0.7;

% Minimum and maximum lambda values
lambda_min   = 0;
lambda_max   = 2.0;

% Loop initialisation
lambda_delta = (lambda_max - lambda_min)/M;
lambda = lambda_min;

bif_y=zeros(N+1,M);
bif_x=bif_y;

% Bifurcation parameter loop
for m = 1:M

   % ignore first T iterates
   yt = y0;
   for n = 1:T
      yt = 1-lambda*yt*yt;
   end
   
   % save the next N iterates
   bif_y(1,m) = yt;
   bif_x(1,m) = lambda;
   for n = 1:N
      bif_y(n+1,m) = 1-lambda*bif_y(n,m)*bif_y(n,m);
      bif_x(n+1,m) = lambda;
   end

   % Update map parameter
   lambda = lambda + lambda_delta;
end

% Plot bifurcation diagram and superpose the zero iterates:
figure; clf('reset');
plot(bif_x, bif_y, 'k.', 'MarkerSize', 2);


hold on;
% add the zero iterates to this plot:
plot(muvals, y, 'linewidth',2);

ax=gca;
defFont=32;
ax.FontSize=defFont; ax.FontName='Times';ax.LineWidth=2.0;
xlabel('\mu','FontSize',1.3*defFont); ylabel('y','FontSize',1.3*defFont,'Rotation',0.0);

axis([lambda_min 1.01*lambda_max  -1 1.1]);

hold off;


function y=f(mu,x)
    y=1.0-mu.*x.*x;  %mu can be a vector, too!
end



end

