function fig5_16
%% To generate contours of the effective potential in a restricted 3-body problem.
% to generate figure 5.16 in our chaos book 2018. 

% r is earth's distance from centre of mass, psi = theta-t is angle but 
% it counter-rotates with sun and jupiter system, h is earth's angular
% momentum, E is kinetic energy plus potential energy (only conserved if
% perturbation epsilon is zero)

% Mark McGuinness

eps=0.001; %the perturbation term

defFont=24;
 
% now get some ICs for contouring the effective potential:
nr=500; ntheta=nr; rmaxmesh=1.3;
r0=linspace(0.7,rmaxmesh,nr);
r0=r0';

% initial psi values:

psi0=linspace(-pi, pi, ntheta);

%===========================================================================
figure(1)
clf('reset')

% Do contours on effective potential for earth, h^2/(2r^2)-1/r - epsilon W:

[r0matrix, psi0matrix]=meshgrid(r0,psi0);

[xmatr, ymatr]= pol2cart(psi0matrix, r0matrix); %convert to cartesian coordinates

VEmatr = GetEarthV(r0matrix,eps,psi0matrix);

Cvals = [-1.50055, -1.5015, linspace(-1.505,-1.55,8)];

hold on;

contour(xmatr, ymatr,VEmatr,Cvals,'LineWidth',1.5); 

% compute the five Lagrange points:
RL1=1+(eps/3)^(1/3); RL2=1-(eps/3)^(1/3); RL3 = 1+3*eps/4; RL45=1-eps/6;  % plot the five Lagrange points too:
L1=[RL1, 0]; L2=[RL2,0]; L3 = [-RL3, 0]; 
L4 = [RL45*cos(pi/3), RL45*sin(pi/3)]; L5= [RL45*cos(-pi/3), RL45*sin(-pi/3)];
LSS=[L1; L2; L3;L4;L5];
display(LSS);
XL=[RL1, RL2, -RL3,  RL45*cos(pi/3), RL45*cos(-pi/3)];
YL= [0, 0, 0, RL45*sin(pi/3), RL45*sin(-pi/3) ];
plot(XL,YL,'ok','MarkerSize',10,'LineWidth',2,'MarkerFaceColor','k');

xlabel('x','FontSize',2*defFont); ylabel('y','FontSize',2*defFont,'Rotation',0.0);

title(['contours on V_E, for \epsilon = ',num2str(eps)])

ax=gca; ax.FontSize=defFont; ax.FontName='Times'; ax.LineWidth=2.0;  ax.Box='on';
colormap('jet')

hold off;



%========================================================================

    function VE = GetEarthV(r,epsilon,psi)
        %get the effective potential for Earth, -1/r - eps * W. Is OK with vector or
        %matrix inputs for  r and psi.
        
        rsq=r.*r;
        
        xsq=1+rsq-2*r.*cos(psi);
        if xsq < 1.0e-16
            x=1.0e-16;
            disp('!!encountered zero or negative x^2 in GetEarthV!!')
            display([r,psi,xsq])
        else
            x=sqrt(xsq);
        end
        
        W = 1./x - cos(psi)./rsq;
        VE=-rsq/2 -1./r -epsilon*W; 
           
    end
  
end