function fig5_18
%% to generate iterates of Henon's Area-preserving Map with alpha=.1328
% To iterate Henon's area-preserving Map, eqn 5.225, 
% producing figure 5.18, and the zoom which is 5.19, in our Chaos book 2019.
% Mark McGuinness

alpha=1.328;

xvec = [0, 0.0603, 0.1207, 0.1810, 0.2413, 0.3017, 0.3620, 0.4223, 0.4823];    
xvec=[xvec, 0.73, 0.77, 0.8, 0.82, 0.84];

yvec=[-0.5000, 0.5000];
xveco=zeros(1,length(yvec));
yveco=zeros(1,length(xvec));

xvec = [xvec, xveco];
yvec = [yveco,yvec];

% plot iterations

figure(1)
clf('reset')
hold on;
nplot=400;
for ii=1:nplot
    [xvec,yvec] = HenonMap(xvec,yvec, alpha);
    plot(xvec, yvec,'.r','MarkerSize',10);
    if norm(xvec) > 10.0
        disp(norm(xvec))
        disp('x getting too big, stopping now')
        disp(ii)
        break  % stop this if it gets too big, which it does
    end
end

    ax=gca;
    axis([-1 1 -1 1]);
    grid off;
    defFont=24;
    ax.FontSize=defFont; ax.FontName='Times';
    ax.XTick=[-1, -0.5, 0, 0.5, 1];
    ax.YTick=[-1, -0.5, 0, 0.5, 1];
    ax.LineWidth=2.0;  ax.Box='on';

    xlabel('x','FontSize',1.3*defFont); ylabel('y','FontSize',1.3*defFont,'Rotation',0.0);
 
    hold off;


    function [xo, yo] = HenonMap(x,y,alpha)
    % the Henon map. Inputs x,y can be matrices or vectors or scalars, but
    % alpha had better be a scalar
    
    xo=cos(alpha)*x +(x.*x-y)*sin(alpha);    % I tried using complex numbers but it blows up
    yo =x*sin(alpha) + cos(alpha)*(y-x.*x);  


    end
end

