function fig5_20
%% To iterate the Standard Map for K=0.5
%To iterate the Standard Map, eqn 5.142, and produce fig 5.20 (final
%label) in our Chaos book. Changing K to 1 will produce fig 5.21.
% look at  cartesian (I, theta) coordinates.

K=0.5; % for Fig 5.20
%K=1.0; % for Fig 5.21
thetavec=linspace(0, 2*pi, 10);
Izeros=zeros(1,length(thetavec));
Ipi=pi*ones(1,length(thetavec));
I2pi=2*Ipi;

Ivec=linspace(0,2*pi,19);
thetazeros=zeros(1,length(Ivec));

thetarr=[thetavec,thetazeros,thetavec,thetavec];
Iarr= [Izeros, Ivec, Ipi, I2pi];
                 
% do some iterations without plotting them:

nskip=100;
for ii=1:nskip
   [thetarr,Iarr] = staMap1(thetarr,Iarr,K);    %does a bunch of ICs at once
end

% plot next lot of iterations, using cartesian coordinates


defFont=24;
figure(1)
clf('reset')

ax1=gca; %save current plot handle as ax1
hold(ax1,'on');
xlabel('\theta','FontSize',1.3*defFont); ylabel('I','FontSize',1.3*defFont,'Rotation',0.0);

nplot=400;
for ii=1:nplot
    [thetarr,Iarr] = staMap1(thetarr,Iarr,K);
    
    plot(ax1,thetarr,Iarr,'.r','MarkerSize',7); %plot cartesian to fig 1
end

    ax=ax1;
    axis(ax,'image');
    ax.DataAspectRatioMode='auto';
    grid off;

    ax.FontSize=defFont; ax.FontName='Times';
    ax.XTick=[0, 0.999*2*pi];
    ax.XTickLabel={ '0', '2\pi'};    
    ax.YTick=[0,  2*pi];
    ax.YTickLabel={'0', '2\pi'};
    ax.LineWidth=2.0;  ax.Box='on';

    hold(ax1,'off');
    

    function [thetao, Io] = staMap1(theta,I,K)
    % the actual standard map. Inputs can be matrices or vectors or scalars
        
    Io=I + K*sin(theta);

    Io=mod(Io+pi,4*pi)-pi; % this is to get Io in [-pi,3pi)
    thetao=theta + Io;  %note that Io appears on RHS, not I

    thetao=mod(thetao,2*pi);  % this puts theta in range [0,2pi)
    
    end

 
end

