function fig6_1b
%% Generates figure 6.1 (b) in Chaos book. An AR process is iterated.
% Due to the use of "randn", this looks a little different every time you 
% run it. It only takes a second to run.
% Mark McGuinness

nvals=500;  % number of iterations of the process to take

alpha=[0.2, -0.4, 0.1, 0.1]; % some AR coefficients
na=length(alpha);

x=ones(nvals,1);
x(1:na) = randn(na,1);
for ii = na:nvals-1
    x(ii+1) = alpha * x(ii-na+1:ii) + randn;
end

figure(1)
clf('reset')

plot(x,'-r','LineWidth',2);
ax=gca;
grid off;
defFont=24;
ax.FontSize=defFont; ax.FontName='Times';
ax.LineWidth=2.0;  ax.Box='on';

xlabel(' ','FontSize',2*defFont); ylabel('x','FontSize',2*defFont,'Rotation',0.0);
 
    

end