% p_2_1_1.m
% Copyright
% T. Schmitz
% June 1, 2008

clc
clear
close all

% Define lumped parameter model
m = 1;              % kg
k = 1e6;            % N/m
c = 200;            % N-s/m

wn = sqrt(k/m);     % rad/s
zeta = c/(2*sqrt(k*m));

% Define FRF
w = (0:0.1:2000)';  % frequency, rad/s
r = w/wn;

FRF_magnitude = 1/k*sqrt(1./((1-r.^2).^2 + (2*zeta*r).^2));     % m/N
FRF_phase = atan2((-2*zeta*r), (1-r.^2));                       % rad
FRF_real = 1/k*(1-r.^2)./((1-r.^2).^2 + (2*zeta*r).^2);         % m/N
FRF_imag = 1/k*(-2*zeta*r)./((1-r.^2).^2 + (2*zeta*r).^2);      % m/N

figure(1)
subplot(211)
plot(r, FRF_magnitude)
axis([0 2 0 5.5e-6])
set(gca,'FontSize', 14)
ylabel('Magnitude (m/N)')
subplot(212)
plot(r, FRF_phase*180/pi)
axis([0 2 -185 5])
set(gca,'FontSize', 14)
xlabel('r', 'FontSize', 14)
ylabel('Phase (deg)')

figure(2)
subplot(211)
plot(r, FRF_real)
axis([0 2 -3e-6 3.5e-6])
set(gca,'FontSize', 14)
ylabel('Real (m/N)')
subplot(212)
plot(r, FRF_imag)
axis([0 2 -5.5e-6 5.5e-7])
set(gca,'FontSize', 14)
xlabel('r')
ylabel('Imag (m/N)')

figure(3)
plot(FRF_real, FRF_imag)
axis([-3e-6 3.5e-6 -5.5e-6 5.5e-7])
set(gca,'FontSize', 14)
xlabel('Real (m/N)')
ylabel('Imag (m/N)')
