% p_2_4_1.m
% Copyright
% T. Schmitz
% June 1, 2008

clc
clear
close all

% Define modal parameters
wn1 = 350.46;       % rad/s
zetaq1 = 0.035;
kq1 = 2.782e5;      % N/m

wn2 = 988.76;       % rad/s
zetaq2 = 0.099;
kq2 = 1.750e6;      % N/m

% Define direct FRF
w = (0:0.2:1500)';  % frequency, rad/s
r1 = w/wn1;
r2 = w/wn2;
Q1_R1 = 1/kq1*((1-r1.^2) - i*(2*zetaq1*r1))./((1-r1.^2).^2 + (2*zetaq1*r1).^2);
Q2_R2 = 1/kq2*((1-r2.^2) - i*(2*zetaq2*r2))./((1-r2.^2).^2 + (2*zetaq2*r2).^2);
FRF_direct = Q1_R1 + Q2_R2;

% Define cross FRF
FRF_cross = 0.7953*Q1_R1 - 0.6287*Q2_R2;

figure(1)
subplot(211)
plot(w, real(FRF_direct))
ylim([-2.7e-5 3.05e-5])
set(gca,'FontSize', 14)
ylabel('Real (m/N)')
subplot(212)
plot(w, imag(FRF_direct))
ylim([-5.5e-5 5.5e-6])
set(gca,'FontSize', 14)
xlabel('Frequency (rad/s)')
ylabel('Imag (m/N)')

figure(2)
subplot(211)
plot(w, real(FRF_cross))
ylim([-2.7e-5 3.05e-5])
set(gca,'FontSize', 14)
ylabel('Real (m/N)')
subplot(212)
plot(w, imag(FRF_cross))
ylim([-5.5e-5 5.5e-6])
set(gca,'FontSize', 14)
xlabel('Frequency (rad/s)')
ylabel('Imag (m/N)')
