% p_2_6_1.m
% Copyright
% T. Schmitz
% June 1, 2008

clc
clear
close all

% Define modal parameters for "measured" FRF
fn1 = 375;          % Hz
wn1 = fn1*2*pi;     % rad/s
zetaq1 = 0.05;
kq1 = 1.5e7;        % N/m

fn2 = 1100;         % Hz
wn2 = fn2*2*pi;     % rad/s
zetaq2 = 0.02;
kq2 = 4e6;          % N/m

fn3 = 4000;         % Hz
wn3 = fn3*2*pi;     % rad/s
zetaq3 = 0.07;
kq3 = 3e6;          % N/m

% Define measured FRF
w = (0:0.2:5000)'*2*pi; % frequency, rad/s
r1 = w/wn1;
r2 = w/wn2;
r3 = w/wn3;
FRF = 1/kq1*((1-r1.^2) - 1i*(2*zetaq1*r1))./((1-r1.^2).^2 + (2*zetaq1*r1).^2) + 1/kq2*((1-r2.^2) - 1i*(2*zetaq2*r2))./((1-r2.^2).^2 + (2*zetaq2*r2).^2) + 1/kq3*((1-r3.^2) - 1i*(2*zetaq3*r3))./((1-r3.^2).^2 + (2*zetaq3*r3).^2);

figure(1)
subplot(211)
plot(w/2/pi, real(FRF), 'r')
ylim([-3.5e-6 4.5e-6])
set(gca,'FontSize', 14)
ylabel('Real (m/N)')
subplot(212)
plot(w/2/pi, imag(FRF), 'r')
ylim([-7.5e-6 7.5e-7])
set(gca,'FontSize', 14)
xlabel('Frequency (Hz)')
ylabel('Imag (m/N)')

figure(2)
subplot(211)
plot(w/2/pi, real(FRF), 'r')
axis([0 2000 -3.5e-6 4.5e-6])
set(gca,'FontSize', 14)
ylabel('Real (m/N)')
hold on
subplot(212)
plot(w/2/pi, imag(FRF), 'r')
axis([0 2000 -7.5e-6 7.5e-7])
set(gca,'FontSize', 14)
xlabel('Frequency (Hz)')
ylabel('Imag (m/N)')
hold on

figure(3)
subplot(211)
plot(w/2/pi, real(FRF), 'r')
axis([0 2000 -3.5e-6 4.5e-6])
set(gca,'FontSize', 14)
ylabel('Real (m/N)')
hold on
subplot(212)
plot(w/2/pi, imag(FRF), 'r')
axis([0 2000 -7.5e-6 7.5e-7])
set(gca,'FontSize', 14)
xlabel('Frequency (Hz)')
ylabel('Imag (m/N)')
hold on

% Perform fit
fn1 = 375;          % Hz
wn1 = fn1*2*pi;     % rad/s
zetaq1 = (393 - 356)*2*pi/(2*wn1)
kq1 = 1/(2*zetaq1*6.74e-7)

fn2 = 1100;         % Hz
wn2 = fn2*2*pi;     % rad/s
zetaq2 = (1122 - 1078)*2*pi/(2*wn2)
kq2 = 1/(2*zetaq2*6.26e-6)

r1 = w/wn1;
r2 = w/wn2;
FRF1 = 1/kq1*((1-r1.^2) - 1i*(2*zetaq1*r1))./((1-r1.^2).^2 + (2*zetaq1*r1).^2);  % mode 1
FRF2 = 1/kq2*((1-r2.^2) - 1i*(2*zetaq2*r2))./((1-r2.^2).^2 + (2*zetaq2*r2).^2);  % mode 2
FRF = FRF1 + FRF2;  % modal fit

figure(2)
subplot(211)
plot(w/2/pi, real(FRF), 'b:')
subplot(212)
plot(w/2/pi, imag(FRF), 'b:')

% Add correction for modal truncation
k = 3e6;            % N/m
FRF = 1/k + FRF1 + FRF2;  % new modal fit

figure(3)
subplot(211)
plot(w/2/pi, real(FRF), 'b:')
subplot(212)
plot(w/2/pi, imag(FRF), 'b:')
