% p_3_3_1.m
% Copyright
% T. Schmitz
% June 1, 2008

clear
close all
clc

% Define modal parameters for two degree of freedom system
kq1 = 2e7;              % N/m
wn1 = 400*2*pi;         % rad/s
zetaq1 = 0.05;

kq2 = 2.2e7;            % N/m
wn2 = 700*2*pi;         % rad/s
zetaq2 = 0.05;

% Define FRF
w = (0:0.5:1400*2*pi);  % frequency, rad/s
r1 = w/wn1;
FRF_real_q1 = 1/kq1*(1-r1.^2)./((1-r1.^2).^2 + (2*zetaq1*r1).^2);
FRF_imag_q1 = 1/kq1*(-2*zetaq1*r1)./((1-r1.^2).^2 + (2*zetaq1*r1).^2);
r2 = w/wn2;
FRF_real_q2 = 1/kq2*(1-r2.^2)./((1-r2.^2).^2 + (2*zetaq2*r2).^2);
FRF_imag_q2 = 1/kq2*(-2*zetaq2*r2)./((1-r2.^2).^2 + (2*zetaq2*r2).^2);

FRF_real = FRF_real_q1 + FRF_real_q2;
FRF_imag = FRF_imag_q1 + FRF_imag_q2;

% Directional orientation factor
mu = cos(70*pi/180);
FRF_real_orient = mu*FRF_real;
FRF_imag_orient = mu*FRF_imag;

figure(1)
subplot(211)
plot(w/2/pi, FRF_real_orient)
axis([0 1400 -1e-7 1.5e-7])
set(gca,'FontSize', 14)
ylabel('Real (m/N)')
subplot(212)
plot(w/2/pi, FRF_imag_orient)
axis([0 1400 -2e-7 2e-8])
set(gca,'FontSize', 14)
xlabel('f (Hz)')
ylabel('Imag (m/N)')

% Determine valid chatter frequency range
index = find(FRF_real_orient < 0);
FRF_real_orient = FRF_real_orient(index);
FRF_imag_orient = FRF_imag_orient(index);
w = w(index);

% Define specific force
Ks = 1.5e9;             % N/m^2

% Calculate blim
blim = -1./(2*Ks*FRF_real_orient);  % m
blim = blim*1e3;        % convert to mm

% Calculate epsilon
epsilon = zeros(1, length(FRF_imag_orient));
for cnt = 1:length(FRF_imag_orient)
    if FRF_imag_orient(cnt) < 0
        epsilon(cnt) = 2*pi - 2*atan(abs(FRF_real_orient(cnt)/FRF_imag_orient(cnt)));
    else
        epsilon(cnt) = pi - 2*atan(abs(FRF_imag_orient(cnt)/FRF_real_orient(cnt)));
    end
end

% Calculate spindle speeds for N = 0 to 2
omega0 = w/(2*pi)./(0 + epsilon/2/pi);   % rps
omega1 = w/(2*pi)./(1 + epsilon/2/pi);
omega2 = w/(2*pi)./(2 + epsilon/2/pi);

figure(2)
subplot(211)
plot(w/2/pi, FRF_real_orient)
axis([0 1400 -1e-7 0])
set(gca,'FontSize', 14)
xlabel('f (Hz)')
ylabel('Real (m/N)')
subplot(212)
plot(omega0, blim)
axis([0 1400 0 15])
set(gca,'FontSize', 14)
xlabel('\Omega (rps)')
ylabel('b_{lim} (mm)')

figure(3)
plot(omega0*60, blim, 'b-', omega1*60, blim, 'r:', omega2*60, blim, 'k--')
axis([5000 60000 0 15])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('b_{lim} (mm)')
