% p_3_4_1.m
% Copyright
% T. Schmitz
% June 1, 2008

clear
close all
clc

% Define parameters for u1 direction
k1 = 2.8e7;             % N/m
wn1 = 421*2*pi;         % rad/s
zeta1 = 0.05;

% Define parameters for u2 direction
k2 = 3.81e7;            % N/m
wn2 = 491*2*pi;         % rad/s
zeta2 = 0.05;

% Define FRFs for two directions
w = (0:0.5:1000*2*pi);  % frequency, rad/s
r1 = w/wn1;
FRF_real_1 = 1/k1*(1-r1.^2)./((1-r1.^2).^2 + (2*zeta1*r1).^2);
FRF_imag_1 = 1/k1*(-2*zeta1*r1)./((1-r1.^2).^2 + (2*zeta1*r1).^2);
r2 = w/wn2;
FRF_real_2 = 1/k2*(1-r2.^2)./((1-r2.^2).^2 + (2*zeta2*r2).^2);
FRF_imag_2 = 1/k2*(-2*zeta2*r2)./((1-r2.^2).^2 + (2*zeta2*r2).^2);

% Convert to mm/N
FRF_real_1 = FRF_real_1*1e3;
FRF_imag_1 = FRF_imag_1*1e3;
FRF_real_2 = FRF_real_2*1e3;
FRF_imag_2 = FRF_imag_2*1e3;

% Directional orientation factors
mu1 = cos((70-30)*pi/180)*cos(30*pi/180);
mu2 = cos((70+60)*pi/180)*cos(60*pi/180);

% Oriented FRF
FRF_real_orient = mu1*FRF_real_1 + mu2*FRF_real_2; 
FRF_imag_orient = mu1*FRF_imag_1 + mu2*FRF_imag_2;

figure(1)
subplot(211)
plot(w/2/pi, FRF_real_orient, 'r-', w/2/pi, mu1*FRF_real_1, 'b:', w/2/pi, mu2*FRF_real_2, 'k-.')
axis([0 1000 -1.8e-4 1.5e-4])
set(gca,'FontSize', 14)
ylabel('Real (mm/N)')
subplot(212)
plot(w/2/pi, FRF_imag_orient, 'r-', w/2/pi, mu1*FRF_imag_1, 'b:', w/2/pi, mu2*FRF_imag_2, 'k-.')
axis([0 1000 -2.7e-4 1.4e-4])
set(gca,'FontSize', 14)
xlabel('f (Hz)')
ylabel('Imag (mm/N)')

% Determine valid chatter frequency range
index = find(FRF_real_orient < 0);
FRF_real_orient = FRF_real_orient(index);
FRF_imag_orient = FRF_imag_orient(index);
w = w(index);

% Define specific force
Ks = 2000;              % N/mm^2

% Calculate blim
blim = -1./(2*Ks*FRF_real_orient);  % mm

% Calculate epsilon
epsilon = zeros(1, length(FRF_imag_orient));
for cnt = 1:length(FRF_imag_orient)
    if FRF_imag_orient(cnt) < 0
        epsilon(cnt) = 2*pi - 2*atan(abs(FRF_real_orient(cnt)/FRF_imag_orient(cnt)));
    else
        epsilon(cnt) = pi - 2*atan(abs(FRF_imag_orient(cnt)/FRF_real_orient(cnt)));
    end
end

% Calculate spindle speeds for N = 0 to 3
omega0 = w/(2*pi)./(0 + epsilon/2/pi);   % rps
omega1 = w/(2*pi)./(1 + epsilon/2/pi);
omega2 = w/(2*pi)./(2 + epsilon/2/pi);
omega3 = w/(2*pi)./(3 + epsilon/2/pi);

figure(2)
subplot(211)
plot(w/2/pi, FRF_real_orient)
axis([0 1000 -1.7e-4 0])
set(gca,'FontSize', 14)
xlabel('f (Hz)')
ylabel('Real (mm/N)')
subplot(212)
plot(omega0, blim)
axis([0 1000 0 12])
set(gca,'FontSize', 14)
xlabel('\Omega (rps)')
ylabel('b_{lim} (mm)')

figure(3)
plot(omega0*60, blim, 'b-', omega1*60, blim, 'r:', omega2*60, blim, 'k--', omega3*60, blim, 'b-.')
axis([5000 40000 0 12])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('b_{lim} (mm)')
