% p_3_6_1.m
% Copyright
% T. Schmitz
% June 1, 2008

clear
close all
clc

k1 = 2e7;                   % N/m
c1 = 450;                   % N-s/m
m1 = 1;                     % kg
k2 = 3e7;                   % N/m
c2 = 650;                   % N-s/m
m2 = 1;                     % kg

wn1 = sqrt(k1/m1);          % rad/s
zeta1 = c1/2/sqrt(k1*m1);
wn2 = sqrt(k2/m2);          % rad/s
zeta2 = c2/2/sqrt(k2*m2);

w = 0:1500*2*pi;            % frequency vector in rad/s

% u1 direction mode
r1 = w/wn1;
FRF_real_u1 = 1/k1*(1-r1.^2)./((1-r1.^2).^2 + (2*zeta1*r1).^2);         % m/N
FRF_imag_u1 = 1/k1*(-2*zeta1*r1)./((1-r1.^2).^2 + (2*zeta1*r1).^2);

% u2 direction mode
r2 = w/wn2;
FRF_real_u2 = 1/k2*(1-r2.^2)./((1-r2.^2).^2 + (2*zeta2*r2).^2);
FRF_imag_u2 = 1/k2*(-2*zeta2*r2)./((1-r2.^2).^2 + (2*zeta2*r2).^2);

beta = 65*pi/180;
alpha1 = 35*pi/180;
alpha2 = 55*pi/180;

% Directional orientation factors
mu1 = cos(beta - alpha1)*cos(alpha1);
mu2 = cos(beta + alpha2)*cos(alpha2);

FRF_real_orient = mu1*FRF_real_u1 + mu2*FRF_real_u2;
FRF_imag_orient = mu1*FRF_imag_u1 + mu2*FRF_imag_u2;

% Convert to mm/N
FRF_real_orient = FRF_real_orient*1e3;
FRF_imag_orient = FRF_imag_orient*1e3;

figure(1)
subplot(211)
plot(w/2/pi, FRF_real_orient)
axis([0 1500 -2.3e-4 2e-4])
set(gca,'FontSize', 14)
ylabel('Real (mm/N)')
subplot(212)
plot(w/2/pi, FRF_imag_orient)
axis([0 1500 -3.8e-4 1.2e-4])
set(gca,'FontSize', 14)
xlabel('f (Hz)')
ylabel('Imag (mm/N)')

% find minimum value of FRF_real_orient
[FRFmin, index] = min(FRF_real_orient)
fmin = w(index)/2/pi                        % Hz     
