% p_3_6_2.m
% Copyright
% T. Schmitz
% June 1, 2008

clear
close all
clc

% Define dynamic parameters for u1 and u2 directions
% u1
k1 = 2e7;                   % N/m
c1 = 450;                   % N-s/m
m1 = 1;                     % kg
wn1 = sqrt(k1/m1);          % rad/s
zeta1 = c1/2/sqrt(k1*m1);

% u2
k2 = 3e7;                   % N/m
c2 = 650;                   % N-s/m
m2 = 1;                     % kg
wn2 = sqrt(k2/m2);          % rad/s
zeta2 = c2/2/sqrt(k2*m2);

w = 0:1500*2*pi;            % frequency vector in rad/s

% u1 direction mode
r1 = w/wn1;
FRF_real_u1 = 1/k1*(1-r1.^2)./((1-r1.^2).^2 + (2*zeta1*r1).^2);
FRF_imag_u1 = 1/k1*(-2*zeta1*r1)./((1-r1.^2).^2 + (2*zeta1*r1).^2);

% u2 direction mode
r2 = w/wn2;
FRF_real_u2 = 1/k2*(1-r2.^2)./((1-r2.^2).^2 + (2*zeta2*r2).^2);
FRF_imag_u2 = 1/k2*(-2*zeta2*r2)./((1-r2.^2).^2 + (2*zeta2*r2).^2);

beta = 65*pi/180;           % rad
alpha1 = 35*pi/180;
alpha2 = 55*pi/180;

% Directional orientation factors
mu1 = cos(beta - alpha1)*cos(alpha1);
mu2 = cos(beta + alpha2)*cos(alpha2);

FRF_real_orient = mu1*FRF_real_u1 + mu2*FRF_real_u2;
FRF_imag_orient = mu1*FRF_imag_u1 + mu2*FRF_imag_u2;

% Convert to mm/N
FRF_real_orient = FRF_real_orient*1e3;
FRF_imag_orient = FRF_imag_orient*1e3;

figure(1)
subplot(211)
plot(w/2/pi, FRF_real_orient)
axis([0 1500 -2.2e-4 2e-4])
set(gca,'FontSize', 14)
ylabel('Real (m/N)')
subplot(212)
plot(w/2/pi, FRF_imag_orient)
axis([0 1500 -3.8e-4 1.2e-4])
set(gca,'FontSize', 14)
xlabel('f (Hz)')
ylabel('Imag (m/N)')

% Determine valid chatter frequency range
index = find(FRF_real_orient < 0);
FRF_real_orient = FRF_real_orient(index);
FRF_imag_orient = FRF_imag_orient(index);
w = w(index);

% Define specific force
Ks = 2000;                          % N/mm^2

% Calculate blim
blim = -1./(2*Ks*FRF_real_orient);  % mm

% Calculate epsilon
epsilon = zeros(1, length(FRF_imag_orient));
for cnt = 1:length(FRF_imag_orient)
    if FRF_imag_orient(cnt) < 0
        epsilon(cnt) = 2*pi - 2*atan(abs(FRF_real_orient(cnt)/FRF_imag_orient(cnt)));
    else
        epsilon(cnt) = pi - 2*atan(abs(FRF_imag_orient(cnt)/FRF_real_orient(cnt)));
    end
end

% Calculate spindle speeds for N = 0 to 4
omega0 = w/(2*pi)./(0 + epsilon/2/pi);   % rps
omega1 = w/(2*pi)./(1 + epsilon/2/pi);
omega2 = w/(2*pi)./(2 + epsilon/2/pi);
omega3 = w/(2*pi)./(3 + epsilon/2/pi);
omega4 = w/(2*pi)./(4 + epsilon/2/pi);

figure(2)
subplot(211)
plot(w/2/pi, FRF_real_orient)
axis([0 1500 -2.2e-4 0])
set(gca,'FontSize', 14)
xlabel('f (Hz)')
ylabel('Real (mm/N)')
subplot(212)
plot(omega0, blim)
axis([0 1500 0 8])
set(gca,'FontSize', 14)
xlabel('\Omega (rps)')
ylabel('b_{lim} (mm)')

figure(3)
plot(omega0*60, blim, 'b', omega1*60, blim, 'b', omega2*60, blim, 'b', omega3*60, blim, 'b', omega4*60, blim, 'b')
axis([5000 60000 0 8])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('b_{lim} (mm)')
