% p_3_6_3.m
% Copyright
% T. Schmitz
% June 1, 2008
   
clear
close all
clc

% model parameters
k1 = 2e7;                   % N/m
c1 = 450;                   % N-s/m
m1 = 1;                     % kg
k2 = 3e7;                   % N/m
c2 = 650;                   % N-s/m
m2 = 1;                     % kg

beta = 65*pi/180;           % rad
alpha1 = 35*pi/180;
alpha2 = 55*pi/180;

% simulation inputs
omega = 26140;              	        % rpm
fn1 = sqrt(k1/m1)/2/pi;                 % Hz
fn2 = sqrt(k2/m2)/2/pi;                 % Hz
maxfn = max([fn1 fn2]);
dt = 1/(50*maxfn);                      % s
steps_rev = round(1/(dt*omega/60));     % number of steps per revolution
hm = 0.1e-3;  						    % m
Ks = 2e9;   						    % N/m^2
num_rev = 50;                           % number of revolutions
total_steps = num_rev*(steps_rev + 1);	% total steps

u1 = 0; velu1 = 0;  				   	% zero initial conditions
u2 = 0; velu2 = 0;

b = 1e-3;                				% chip width, m

% Set initial surface for one revolution 
for n = 1:(steps_rev) 
	y(n) = 0;
end                             
	
% Simulation begins here
for n = (steps_rev + 1):total_steps
   ymin = hm + y(n-steps_rev);          % instantaneous depth of cut     
		
   for cnt = 1:(num_rev-1)              % Check all preceeding passes for lowest cut 
      if n > cnt*steps_rev
         ymin = hm + y(n-steps_rev);
         y1 = cnt*hm + y(n-cnt*steps_rev);
         if y1 < ymin
            ymin = y1;
         end
      end
   end
            
   F = Ks*b*(ymin - y(n-1));
   if F < 0                     % no cutting
      F = 0;
      y(n-1) = ymin;
   end
   Fu1 = F*cos(beta - alpha1);
   Fu2 = F*cos(beta + alpha2);
   Force(n) = F;                % N
      
   % Perform Euler integrations 
   % u1 direction
   accu1 = (Fu1 - c1*velu1 - k1*u1)/m1;
   velu1 = velu1 + accu1*dt;
   u1 = u1 + velu1*dt;
   
   % u2 direction
   accu2 = (Fu2 - c2*velu2 - k2*u2)/m2;
   velu2 = velu2 + accu2*dt;
   u2 = u2 + velu2*dt;

   % Normal direction
   y(n) = u1*cos(alpha1) + u2*cos(alpha2);  % m
   t(n) = (n - steps_rev - 1)*dt;           % s
end  % end of simulation for loop 

% Plot results
figure(1)
subplot(211)
plot(t, y*1e6)
axis([0 max(t) -5 15])
set(gca,'FontSize', 14)
ylabel('y (\mum)')
subplot(212)
plot(t, Force)
axis([0 max(t) 0 240])
set(gca,'FontSize', 14)
ylabel('F (N)')
xlabel('t (s)')
