% p_3_7_1.m
% Copyright
% T. Schmitz
% January 1, 2018

clear
close all
clc

% Define modal parameters for single degree of freedom system
k = 6.48e6;             % stiffness, N/m
wn = 3398.6;            % natural frequency, rad/s
zeta = 0.038;           % damping ratio

% Define FRF
w = (0:0.5:2*wn);       % frequency, rad/s
r = w/wn;
FRF_real = 1/k*(1-r.^2)./((1-r.^2).^2 + (2*zeta*r).^2);
FRF_imag = 1/k*(-2*zeta*r)./((1-r.^2).^2 + (2*zeta*r).^2);

% Define force model
Ks = 2927e6;            % specific cutting force, N/m^2
beta = 61.79*pi/180;    % force angle, rad

% Define oriented FRF
alpha = 0;
mu = cos(beta - alpha)*cos(alpha);
FRF_real_orient = mu*FRF_real;
FRF_imag_orient = mu*FRF_imag;

% Determine valid chatter frequency range
index = find(FRF_real_orient < 0);
FRF_real_orient = FRF_real_orient(index);
FRF_imag_orient = FRF_imag_orient(index);
w = w(index);

% Calculate blim
blim = -1./(2*Ks*FRF_real_orient);  % m
blim = blim*1e3;        % convert to mm

% Calculate epsilon
epsilon = zeros(1, length(FRF_imag_orient));
for cnt = 1:length(FRF_imag_orient)
    if FRF_imag_orient(cnt) < 0
        epsilon(cnt) = 2*pi - 2*atan(abs(FRF_real_orient(cnt)/FRF_imag_orient(cnt)));
    else
        epsilon(cnt) = pi - 2*atan(abs(FRF_imag_orient(cnt)/FRF_real_orient(cnt)));
    end
end

% Calculate spindle speeds for N = 0
N = 0;
omega = w/(2*pi)./(N + epsilon/2/pi)*60;   % rpm

figure(1)
plot(omega, blim, 'b-')
axis([0 4000 0 2])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('b_{lim} (mm)')
grid
hold on

for N = 1:60
    omega = w/(2*pi)./(N + epsilon/2/pi)*60;
    plot(omega, blim, 'b-')
end
