% p_3_7_3.m
% Copyright
% T. Schmitz
% January 1, 2018

clear
close all
clc

% Define converging analysis parameters
iterations = 20;
num_lobes = 60;

% Carry out calculations starting at selected N = n
n = 8;

% Define workpiece diameter
d = 0.035;              % m

% Define dynamic parameters for u direction
k = 6.48e6;             % stiffness, N/m
wn = 3398.6;            % natural frequency, rad/s
zeta = 0.038;           % damping ratio
m = k/(wn)^2;           % mass, kg
c = 2*zeta*sqrt(k*m);   % damping coefficient, N-s/m

% Define force model
Ks = 2927e6;            % specific cutting force, N/m^2
beta = 61.79*pi/180;    % force angle, rad
C = 6.11e5;             % process damping coefficient, N/m

% Define directional orientation factor
alpha = 0;
mu = cos(beta - alpha)*cos(alpha);

w = 0:2*wn;             % frequency vector in rad/s

% u direction mode
r = w/wn;
FRF_real = 1/k*(1-r.^2)./((1-r.^2).^2 + (2*zeta*r).^2);
FRF_imag = 1/k*(-2*zeta*r)./((1-r.^2).^2 + (2*zeta*r).^2);

% Define oriented FRF
FRF_real_orient = mu*FRF_real;
FRF_imag_orient = mu*FRF_imag;

% Determine valid chatter frequency range
index = find(FRF_real_orient < 0);
FRF_real_orient = FRF_real_orient(index);
FRF_imag_orient = FRF_imag_orient(index);
w = w(index);

% Calculate blim
blim = -1./(2*Ks*FRF_real_orient);  % m

% Calculate epsilon
epsilon = zeros(1, length(FRF_imag_orient));
for cnt = 1:length(FRF_imag_orient)
    if FRF_imag_orient(cnt) < 0
        epsilon(cnt) = 2*pi - 2*atan(abs(FRF_real_orient(cnt)/FRF_imag_orient(cnt)));
    else
        epsilon(cnt) = pi - 2*atan(abs(FRF_imag_orient(cnt)/FRF_real_orient(cnt)));
    end
end

% Calculate spindle speeds
omega = w/(2*pi)./(n + epsilon/2/pi)*60;   % rpm

% Iterate on initial solution
for loop = 1:iterations
    v = pi*d*omega/60;
    
    cnew = c + C*blim./v*(cos(alpha))^2;
    zeta = cnew/(2*sqrt(k*m));
    
    r = w/wn;
    FRF_real = 1/k*(1-r.^2)./((1-r.^2).^2 + (2*zeta.*r).^2);
    FRF_imag = 1/k*(-2*zeta.*r)./((1-r.^2).^2 + (2*zeta.*r).^2);

    % Define oriented FRF
    FRF_real_orient = mu*FRF_real;
    FRF_imag_orient = mu*FRF_imag;

    % Determine valid chatter frequency range
    index = find(FRF_real_orient < 0);
    FRF_real_orient = FRF_real_orient(index);
    FRF_imag_orient = FRF_imag_orient(index);
    w = w(index);

    % Calculate blim
    blim = -1./(2*Ks*FRF_real_orient);  % m

    % Calculate epsilon
    epsilon = zeros(1, length(FRF_imag_orient));
    for cnt = 1:length(FRF_imag_orient)
        if FRF_imag_orient(cnt) < 0
            epsilon(cnt) = 2*pi - 2*atan(abs(FRF_real_orient(cnt)/FRF_imag_orient(cnt)));
        else
            epsilon(cnt) = pi - 2*atan(abs(FRF_imag_orient(cnt)/FRF_real_orient(cnt)));
        end
    end

    % Calculate spindle speeds
    omega = w/(2*pi)./(n + epsilon/2/pi)*60;   % rpm
end

figure(1)
plot(omega, blim*1e3, 'b-')
axis([0 4000 0 2])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('b_{lim} (mm)')
grid
hold on

for n = (n + 1):num_lobes
    % Determine initial lobe behvior
    w = 0:2*wn;            % frequency vector in rad/s
    
    % Define dynamic parameters for u direction
    k = 6.48e6;             % stiffness, N/m
    wn = 3398.6;            % natural frequency, rad/s
    zeta = 0.038;           % damping ratio
    m = k/(wn)^2;           % mass, kg
    c = 2*zeta*sqrt(k*m);   % damping coefficient, N-s/m
    
    % u direction mode
    r = w/wn;
    FRF_real = 1/k*(1-r.^2)./((1-r.^2).^2 + (2*zeta*r).^2);
    FRF_imag = 1/k*(-2*zeta*r)./((1-r.^2).^2 + (2*zeta*r).^2);
    
    % Define oriented FRF
    FRF_real_orient = mu*FRF_real;
    FRF_imag_orient = mu*FRF_imag;
    
    % Determine valid chatter frequency range
    index = find(FRF_real_orient < 0);
    FRF_real_orient = FRF_real_orient(index);
    FRF_imag_orient = FRF_imag_orient(index);
    w = w(index);
    
    % Calculate blim
    blim = -1./(2*Ks*FRF_real_orient);  % m
    
    % Calculate epsilon
    epsilon = zeros(1, length(FRF_imag_orient));
    for cnt = 1:length(FRF_imag_orient)
        if FRF_imag_orient(cnt) < 0
            epsilon(cnt) = 2*pi - 2*atan(abs(FRF_real_orient(cnt)/FRF_imag_orient(cnt)));
        else
            epsilon(cnt) = pi - 2*atan(abs(FRF_imag_orient(cnt)/FRF_real_orient(cnt)));
        end
    end

    % Calculate spindle speeds
    omega = w/(2*pi)./(n + epsilon/2/pi)*60;   % rpm
    
    % Iterate on initial solution
    for loop = 1:iterations
        v = pi*d*omega/60;
    
        cnew = c + C*blim./v*(cos(alpha))^2;
        zeta = cnew/(2*sqrt(k*m));
        
        r = w/wn;
        FRF_real = 1/k*(1-r.^2)./((1-r.^2).^2 + (2*zeta.*r).^2);
        FRF_imag = 1/k*(-2*zeta.*r)./((1-r.^2).^2 + (2*zeta.*r).^2);
        
        % Define oriented FRF
        FRF_real_orient = mu*FRF_real;
        FRF_imag_orient = mu*FRF_imag;
        
        % Determine valid chatter frequency range
        index = find(FRF_real_orient < 0);
        FRF_real_orient = FRF_real_orient(index);
        FRF_imag_orient = FRF_imag_orient(index);
        w = w(index);
        
        % Calculate blim
        blim = -1./(2*Ks*FRF_real_orient);  % m
        
        % Calculate epsilon
        epsilon = zeros(1, length(FRF_imag_orient));
        for cnt = 1:length(FRF_imag_orient)
            if FRF_imag_orient(cnt) < 0
                epsilon(cnt) = 2*pi - 2*atan(abs(FRF_real_orient(cnt)/FRF_imag_orient(cnt)));
            else
                epsilon(cnt) = pi - 2*atan(abs(FRF_imag_orient(cnt)/FRF_real_orient(cnt)));
            end
        end
        
        % Calculate spindle speeds
        omega = w/(2*pi)./(n + epsilon/2/pi)*60;   % rpm
    end
    
    plot(omega, blim*1e3, 'b-')
end
