% p_3_8_1.m
% Copyright
% T. Schmitz
% January 1, 2018
   
clear
close all
clc

% Define dynamic parameters for u direction
k = 6.48e6;                     % stiffness, N/m
c = 145;                        % damping coefficient, N-s/m
m = 0.561;                      % mass, kg
fn = sqrt(k/m)/2/pi;            % natural frequency, Hz

% Define simulation inputs
omega = 1000;                 	        % spindle speed, rpm
b = 1e-3;                				% chip width, m
hm = 0.1e-3;  						    % mean chip thickness, m
Ks = 2927e6;   						    % specific cutting force, N/m^2
beta = 61.79*pi/180;                    % force angle, rad
C = 6.11e5;                             % process damping coefficient, N/m
alpha = 0;
d = 0.035;                              % workpiece diameter, m
v = pi*d*omega/60;                      % cutting speed, m/s

dt = 1/(50*fn);                         % time step, s
steps_rev = round(1/(dt*omega/60));     % number of steps per revolution
num_rev = 20;                           % number of revolutions
total_steps = num_rev*(steps_rev + 1);	% total steps

u = 0; velu = 0;                        % zero initial conditions

% Set initial surface for one revolution 
for n = 1:(steps_rev) 
	y(n) = 0;
end                             

% Simulation begins here
for n = (steps_rev + 1):total_steps
   ymin = hm + y(n-steps_rev);
		
   for cnt = 1:(num_rev-1)              % check all preceeding passes for lowest cut 
      if n > cnt*steps_rev
         ymin = hm + y(n-steps_rev);
         y1 = cnt*hm + y(n-cnt*steps_rev);
         if y1 < ymin
            ymin = y1;
         end
      end
   end
   
   F = Ks*b*(ymin - y(n-1));
   if F < 0                     % no cutting
      F = 0;
      y(n-1) = ymin;
   end
   Fu = F*cos(beta - alpha) - C*b/v*(cos(alpha))^2*velu;    % include process damping
   Force(n) = Fu/cos(beta - alpha); % N
      
   % Perform Euler integrations 
   % u direction
   accu = (Fu - c*velu - k*u)/m;
   velu = velu + accu*dt;
   u = u + velu*dt;
   
   % Normal direction
   y(n) = u*cos(alpha);             % m
   t(n) = (n - steps_rev - 1)*dt;   % s
end  % end of simulation for loop 

% Plot results
figure(1)
subplot(211)
plot(t, y*1e6)
axis([0 max(t) -200 200])
set(gca,'FontSize', 14)
ylabel('y (\mum)')
subplot(212)
plot(t, Force)
axis([0 max(t) 0 1300])
set(gca,'FontSize', 14)
ylabel('F (N)')
xlabel('t (s)')
