% p_4_10_1.m
% Copyright
% T. Schmitz
% June 1, 2008

close all
clear
clc

% Define cutting force coefficients
Ks = 750e6;                         % N/m^2
beta = 68;                          % deg
kt = Ks*sin(beta*pi/180);
kn = Ks*cos(beta*pi/180);

% Define parameters for x direction
kx = 8e6;                           % N/m
zetax = 0.02;
wnx = 500*2*pi;                     % rad/s
mx = kx/(wnx^2);                    % kg
cx = 2*zetax*sqrt(mx*kx);           % N-s/m

% Define parameters for y direction
ky = 8e6;                           % N/m
zetay = 0.02;
wny = 500*2*pi;                     % rad/s
my = ky/(wny^2);                    % kg
cy = 2*zetay*sqrt(my*ky);           % N-s/m

% Define cutting parameters
Nt = 4;
phis = 0;                           % deg
phie = 180;                         % deg
omega = 5000;                       % rpm
b = 0.5e-3;                         % m
ft = 0.15e-3;                       % m/tooth
steps_rev = 650;

% Calculate actual steps_rev to ensure integer value
% for ratio (steps_rev/Nt)
temp = round(steps_rev/Nt);
steps_rev = temp*Nt;
dt = 60/(steps_rev*omega);          % s
dphi = 360/steps_rev;               % deg
rev = 20;
steps = rev*steps_rev;

% Initialize vectors
for cnt = 1:Nt
    teeth(cnt) = (cnt-1)*steps_rev/Nt + 1;
end
for cnt = 1:steps_rev
    phi(cnt) = (cnt - 1)*dphi;
end
for cnt = 1:steps_rev
    surf(cnt) = 0;
end

% Define initial conditions
x = 0;
dx = 0;
y = 0;
dy = 0;

for cnt1 = 1:steps
    time(cnt1) = dt*cnt1;
    for cnt2 = 1:Nt
        teeth(cnt2) = teeth(cnt2) + 1;
        if teeth(cnt2) > steps_rev
            teeth(cnt2) = 1;
        end
    end
    Fx = 0;
    Fy = 0;
    for cnt3 = 1:Nt
        if ((phi(teeth(cnt3)) >= phis) && (phi(teeth(cnt3)) <= phie))
            n = (x*sin(phi(teeth(cnt3))*pi/180) - y*cos(phi(teeth(cnt3))*pi/180));  % m
            h = ft*sin(phi(teeth(cnt3))*pi/180) + surf(teeth(cnt3)) - n;            % m
            Ft = kt*b*h;    % N
            if Ft < 0
                Ft = 0;
                surf(teeth(cnt3)) = surf(teeth(cnt3)) + ft*sin(phi(teeth(cnt3))*pi/180);
            else
                surf(teeth(cnt3)) = n;
            end
        else
            Ft = 0;
        end

        Fn = kn/kt*Ft;
        Fx = Fx + Ft*cos(phi(teeth(cnt3))*pi/180) + Fn*sin(phi(teeth(cnt3))*pi/180);
        Fy = Fy + Ft*sin(phi(teeth(cnt3))*pi/180) - Fn*cos(phi(teeth(cnt3))*pi/180);
    end
    Forcex(cnt1) = Fx;
    Forcey(cnt1) = Fy;

    % Numerical integration for position
    ddx = (Fx - cx*dx - kx*x)/mx;
    dx = dx + ddx*dt;
    x = x + dx*dt;
    xpos(cnt1) = x;

    ddy = (Fy - cy*dy - ky*y)/my;
    dy = dy + ddy*dt;
    y = y + dy*dt;
    ypos(cnt1) = y;
end

figure(1)
subplot(211)
plot(time, Forcex)
xlim([0 max(time)]) 
set(gca,'FontSize', 14)
ylabel('F_x (N)')
subplot(212)
plot(time, xpos*1e6)
xlim([0 max(time)]) 
set(gca,'FontSize', 14)
xlabel('t (s)')
ylabel('x (\mum)')

figure(2)
subplot(211)
plot(time, Forcey)
xlim([0 max(time)]) 
set(gca,'FontSize', 14)
ylabel('F_y (N)')
subplot(212)
plot(time, ypos*1e6)
xlim([0 max(time)]) 
set(gca,'FontSize', 14)
xlabel('t (s)')
ylabel('y (\mum)')

F = (Forcex.^2 + Forcey.^2).^0.5;   % N
figure(3)
plot(time, F)
xlim([0 max(time)]) 
set(gca,'FontSize', 14)
xlabel('t (s)')
ylabel('F (N)')
