% p_4_14_2.m
% Copyright
% T. Schmitz
% June 1, 2008

clear
close all
clc

% Average tooth angle approach
% Define modal parameters for x direction
kx1 = 2e7;              % N/m
wnx1 = 800*2*pi;        % rad/s
zetax1 = 0.05;
kx2 = 1.5e7;            % N/m
wnx2 = 1000*2*pi;       % rad/s
zetax2 = 0.03;

% Define parameters for y direction
ky1 = 2e7;              % N/m
wny1 = 800*2*pi;        % rad/s
zetay1 = 0.05;
ky2 = 1.5e7;            % N/m
wny2 = 1000*2*pi;       % rad/s
zetay2 = 0.03;

% Define specific force and force angle
Ks = 600;               % N/mm^2
beta = 60;              % deg

% Define FRFs for two directions
w = (0:0.5:2000*2*pi);  % frequency, rad/s
rx1 = w/wnx1;
rx2 = w/wnx2;
FRF_real_x = 1/kx1*(1-rx1.^2)./((1-rx1.^2).^2 + (2*zetax1*rx1).^2) + 1/kx2*(1-rx2.^2)./((1-rx2.^2).^2 + (2*zetax2*rx2).^2);
FRF_imag_x = 1/kx1*(-2*zetax1*rx1)./((1-rx1.^2).^2 + (2*zetax1*rx1).^2) + 1/kx2*(-2*zetax2*rx2)./((1-rx2.^2).^2 + (2*zetax2*rx2).^2);
ry1 = w/wny1;
ry2 = w/wny2;
FRF_real_y = 1/ky1*(1-ry1.^2)./((1-ry1.^2).^2 + (2*zetay1*ry1).^2) + 1/ky2*(1-ry2.^2)./((1-ry2.^2).^2 + (2*zetay2*ry2).^2);
FRF_imag_y = 1/ky1*(-2*zetay1*ry1)./((1-ry1.^2).^2 + (2*zetay1*ry1).^2) + 1/ky2*(-2*zetay2*ry2)./((1-ry2.^2).^2 + (2*zetay2*ry2).^2);

% Convert to mm/N
FRF_real_x = FRF_real_x*1e3;
FRF_imag_x = FRF_imag_x*1e3;
FRF_real_y = FRF_real_y*1e3;
FRF_imag_y = FRF_imag_y*1e3;

figure(1)
subplot(211)
plot(w/2/pi, FRF_real_x)
axis([0 2000 -8e-4 7e-4])
set(gca,'FontSize', 14)
ylabel('Real (mm/N)')
subplot(212)
plot(w/2/pi, FRF_imag_x)
axis([0 2000 -1.4e-3 1.4e-4])
set(gca,'FontSize', 14)
xlabel('f (Hz)')
ylabel('Imag (mm/N)')

% Directional orientation factors
mux = cos((beta - 56.8)*pi/180)*cos(56.8*pi/180);
muy = cos((146.8 - beta)*pi/180)*cos(146.8*pi/180);

% Oriented FRF
FRF_real_orient = mux*FRF_real_x + muy*FRF_real_y; 
FRF_imag_orient = mux*FRF_imag_x + muy*FRF_imag_y;

% Determine valid chatter frequency range
index = find(FRF_real_orient < 0);
FRF_real_orient = FRF_real_orient(index);
FRF_imag_orient = FRF_imag_orient(index);
w = w(index);

% Define average number of teeth in cut, Nt_star
Nt = 4;
phis = 0;           % deg
phie = 66.4;
Nt_star = (phie - phis)*Nt/360;

% Calculate blim
blim = -1./(2*Ks*FRF_real_orient*Nt_star);  % mm

% Calculate epsilon
epsilon = zeros(1, length(FRF_imag_orient));
for cnt = 1:length(FRF_imag_orient)
    if FRF_imag_orient(cnt) < 0
        epsilon(cnt) = 2*pi - 2*atan(abs(FRF_real_orient(cnt)/FRF_imag_orient(cnt)));
    else
        epsilon(cnt) = pi - 2*atan(abs(FRF_imag_orient(cnt)/FRF_real_orient(cnt)));
    end
end

% Calculate spindle speeds for N = 0 to 4
omega0 = w/(Nt*2*pi)./(0 + epsilon/2/pi);   % rps
omega1 = w/(Nt*2*pi)./(1 + epsilon/2/pi);
omega2 = w/(Nt*2*pi)./(2 + epsilon/2/pi);
omega3 = w/(Nt*2*pi)./(3 + epsilon/2/pi);
omega4 = w/(Nt*2*pi)./(4 + epsilon/2/pi);

figure(2)
plot(omega0*60, blim, 'b-', omega1*60, blim, 'b-', omega2*60, blim, 'b-', omega3*60, blim, 'b-', omega4*60, blim, 'b-')
axis([0 30000 0 20])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('b_{lim} (mm)')

clear

% Fourier series approach
% Define modal parameters for x direction
kx1 = 2e7;              % N/m
wnx1 = 800*2*pi;        % rad/s
zetax1 = 0.05;
kx2 = 1.5e7;            % N/m
wnx2 = 1000*2*pi;       % rad/s
zetax2 = 0.03;

% Define parameters for y direction
ky1 = 2e7;              % N/m
wny1 = 800*2*pi;        % rad/s
zetay1 = 0.05;
ky2 = 1.5e7;            % N/m
wny2 = 1000*2*pi;       % rad/s
zetay2 = 0.03;

phis = 0*pi/180;        % rad
phie = 66.4*pi/180;     % rad

% Cutting force coefficients
Ks = 600e6;             % N/m^2
beta = 60;              % deg
Kn = 1/tan(beta*pi/180);
Kt = Ks/sqrt(1 + Kn^2); % N/m^2
Nt = 4;

alphaxx = 0.5*((cos(2*phie)-2*Kn*phie+Kn*sin(2*phie))-(cos(2*phis)-2*Kn*phis+Kn*sin(2*phis)));
alphaxy = 0.5*((-sin(2*phie)-2*phie+Kn*cos(2*phie))-(-sin(2*phis)-2*phis+Kn*cos(2*phis)));
alphayx = 0.5*((-sin(2*phie)+2*phie+Kn*cos(2*phie))-(-sin(2*phis)+2*phis+Kn*cos(2*phis)));
alphayy = 0.5*((-cos(2*phie)-2*Kn*phie-Kn*sin(2*phie))-(-cos(2*phis)-2*Kn*phis-Kn*sin(2*phis)));

wnmax = max([max([wnx1 wnx2]) max([wny1 wny2])]);
w = (0:0.1:2*wnmax/2/pi)'*2*pi;   % frequency, rad/s
FRFxx = (wnx1^2/kx1)./(wnx1^2 - w.^2 + 1i*2*zetax1*wnx1.*w) + (wnx2^2/kx2)./(wnx2^2 - w.^2 + 1i*2*zetax2*wnx2.*w);
FRFyy = (wny2^2/ky2)./(wny2^2 - w.^2 + 1i*2*zetay2*wny2.*w) + (wny2^2/ky2)./(wny2^2 - w.^2 + 1i*2*zetay2*wny2.*w);

for cnt = 1:length(w)
    % Oriented FRF
    FRF_or = [alphaxx*FRFxx(cnt) alphaxy*FRFyy(cnt); alphayx*FRFxx(cnt) alphayy*FRFyy(cnt)];    % m/N
    % Calculate two eigenvalues
    E = eig(FRF_or);
    temp = E(1);
    lambda1(cnt) = temp;
    temp = E(2);
    lambda2(cnt) = temp;
    if (cnt > 1)
        dot_prod1 = real(lambda2(cnt))*real(lambda2(cnt-1)) + imag(lambda2(cnt))*imag(lambda2(cnt-1));
        dot_prod2 = real(lambda2(cnt))*real(lambda1(cnt-1)) + imag(lambda2(cnt))*imag(lambda1(cnt-1));
        if (dot_prod2 > dot_prod1)
            temp = lambda2(cnt);
            lambda2(cnt) = lambda1(cnt);
            lambda1(cnt) = temp;
        end
    end
end

lambda1 = lambda1';
lambda2 = lambda2';

blim1 = (2*pi/Nt/Kt)./((real(lambda1)).^2 + (imag(lambda1)).^2) .* (real(lambda1) .* (1 + (imag(lambda1)./real(lambda1)).^2));  % m
blim2 = (2*pi/Nt/Kt)./((real(lambda2)).^2 + (imag(lambda2)).^2) .* (real(lambda2) .* (1 + (imag(lambda2)./real(lambda2)).^2));

[index1] = find(blim1 > 0);
blim1 = blim1(index1);
blim1 = blim1*1e3;      % mm
w1 = w(index1);
psi1 = atan2(imag(lambda1), real(lambda1));
psi1 = psi1(index1);
epsilon1 = pi - 2*psi1;
omega11 = (60/Nt)*w1./(epsilon1 + 2*0*pi);     % rpm
omega12 = (60/Nt)*w1./(epsilon1 + 2*1*pi);
omega13 = (60/Nt)*w1./(epsilon1 + 2*2*pi);
omega14 = (60/Nt)*w1./(epsilon1 + 2*3*pi);
omega15 = (60/Nt)*w1./(epsilon1 + 2*4*pi);

[index2] = find(blim2 > 0);
blim2 = blim2(index2);
blim2 = blim2*1e3;
w2 = w(index2);
psi2 = atan2(imag(lambda2), real(lambda2));
psi2 = psi2(index2);
epsilon2 = pi - 2*psi2;
omega21 = (60/Nt)*w2./(epsilon2 + 2*0*pi);
omega22 = (60/Nt)*w2./(epsilon2 + 2*1*pi);
omega23 = (60/Nt)*w2./(epsilon2 + 2*2*pi);
omega24 = (60/Nt)*w2./(epsilon2 + 2*3*pi);
omega25 = (60/Nt)*w2./(epsilon2 + 2*4*pi);

figure(3)
% First eigenvalue
plot(omega11, blim1, 'b:', omega12, blim1, 'b:', omega13, blim1, 'b:', omega14, blim1, 'b:', omega15, blim1, 'b:')
hold on
% Second eigenvalue
plot(omega21, blim2, 'b', omega22, blim2, 'b', omega23, blim2, 'b', omega24, blim2, 'b', omega25, blim2, 'b')
axis([0 30000 0 20])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('b_{lim} (mm)')
