% p_4_17_1.m
% Copyright
% T. Schmitz
% January 1, 2018

clear
close all
clc

% Define parameters for x direction
kx = 9e6;               % N/m
wnx = 900*2*pi;         % rad/s
zetax = 0.03;

% Define parameters for y direction
ky = 9e6;                   % N/m
wny = 900*2*pi;             % rad/s
zetay = 0.03;

% Define specific force and force angle
Ks = 2000e6;            % N/m^2
beta = 70*pi/180;       % deg

% Define FRFs for two directions
wnmax = max([wnx wny]);
w = (0:0.1:2*wnmax);        % frequency, rad/s
rx = w/wnx;
FRF_real_x = 1/kx*(1-rx.^2)./((1-rx.^2).^2 + (2*zetax*rx).^2);
FRF_imag_x = 1/kx*(-2*zetax*rx)./((1-rx.^2).^2 + (2*zetax*rx).^2);
ry = w/wny;
FRF_real_y = 1/ky*(1-ry.^2)./((1-ry.^2).^2 + (2*zetay*ry).^2);
FRF_imag_y = 1/ky*(-2*zetay*ry)./((1-ry.^2).^2 + (2*zetay*ry).^2);

% Define average number of teeth in cut, Nt_star
Nt = 3;
phis = 0;                   % entry angle, deg
phie = 90;                  % exit angle, deg
phiave = (phis + phie)/2;   % average tooth angle, deg
Nt_star = (phie - phis)*Nt/360;

% Directional orientation factors
mux = cos((beta - (pi/2 - phiave*pi/180)))*cos(pi/2 - phiave*pi/180);
muy = cos((pi - phiave*pi/180) - beta)*cos(pi - phiave*pi/180);

% Oriented FRF
FRF_real_orient = mux*FRF_real_x + muy*FRF_real_y; 
FRF_imag_orient = mux*FRF_imag_x + muy*FRF_imag_y;

% Determine valid chatter frequency range
index = find(FRF_real_orient < 0);
FRF_real_orient = FRF_real_orient(index);
FRF_imag_orient = FRF_imag_orient(index);
w = w(index);

% Calculate blim
blim = -1./(2*Ks*FRF_real_orient*Nt_star);  % m

% Calculate epsilon
epsilon = zeros(1, length(FRF_imag_orient));
for cnt = 1:length(FRF_imag_orient)
    if FRF_imag_orient(cnt) < 0
        epsilon(cnt) = 2*pi - 2*atan(abs(FRF_real_orient(cnt)/FRF_imag_orient(cnt)));
    else
        epsilon(cnt) = pi - 2*atan(abs(FRF_imag_orient(cnt)/FRF_real_orient(cnt)));
    end
end

% Calculate spindle speeds for N = 0
N = 0;
omega = w/(Nt*2*pi)./(N + epsilon/2/pi)*60;   % rpm

figure(1)
plot(omega, blim*1e3, 'b-')
axis([0 10000 0 10])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('b_{lim} (mm)')
grid
hold on

for N = 1:200
    omega = w/(Nt*2*pi)./(N + epsilon/2/pi)*60;
    plot(omega, blim*1e3, 'b-')
end
