% p_4_6_1.m
% Copyright
% T. Schmitz
% June 1, 2008

clear all
close all
clc

% Define parameters for x direction
kx = 8e6;               % N/m
wnx = 500*2*pi;         % rad/s
zetax = 0.02;

% Define parameters for y direction
ky = 8e6;               % N/m
wny = 500*2*pi;         % rad/s
zetay = 0.02;

% Define specific force and force angle
Ks = 750;               % N/mm^2
beta = 68;              % deg

% Define FRFs for two directions
w = (0:0.5:1000*2*pi);  % frequency, rad/s
rx = w/wnx;
FRF_real_x = 1/kx*(1-rx.^2)./((1-rx.^2).^2 + (2*zetax*rx).^2);
FRF_imag_x = 1/kx*(-2*zetax*rx)./((1-rx.^2).^2 + (2*zetax*rx).^2);
ry = w/wny;
FRF_real_y = 1/ky*(1-ry.^2)./((1-ry.^2).^2 + (2*zetay*ry).^2);
FRF_imag_y = 1/ky*(-2*zetay*ry)./((1-ry.^2).^2 + (2*zetay*ry).^2);

% Convert to mm/N
FRF_real_x = FRF_real_x*1e3;
FRF_imag_x = FRF_imag_x*1e3;
FRF_real_y = FRF_real_y*1e3;
FRF_imag_y = FRF_imag_y*1e3;

% Directional orientation factors for slotting
mux = cos(beta*pi/180);
muy = 0;

% Oriented FRF
FRF_real_orient = mux*FRF_real_x + muy*FRF_real_y; 
FRF_imag_orient = mux*FRF_imag_x + muy*FRF_imag_y;

figure(1)
subplot(211)
plot(w/2/pi, FRF_real_orient)
axis([0 1000 -7e-4 7e-4])
set(gca,'FontSize', 14)
ylabel('Real (mm/N)')
subplot(212)
plot(w/2/pi, FRF_imag_orient)
axis([0 1000 -1.3e-3 1.3e-4])
set(gca,'FontSize', 14)
xlabel('f (Hz)')
ylabel('Imag (mm/N)')

% Determine valid chatter frequency range
index = find(FRF_real_orient < 0);
FRF_real_orient = FRF_real_orient(index);
FRF_imag_orient = FRF_imag_orient(index);
w = w(index);

% Define average number of teeth in cut, Nt_star
Nt = 4;
phis = 0;       % deg
phie = 180;
Nt_star = (phie - phis)*Nt/360;

% Calculate blim
blim = -1./(2*Ks*FRF_real_orient*Nt_star);  % mm

% Calculate epsilon
for cnt = 1:length(FRF_imag_orient)
    if FRF_imag_orient(cnt) < 0
        epsilon(cnt) = 2*pi - 2*atan(abs(FRF_real_orient(cnt)/FRF_imag_orient(cnt)));
    else
        epsilon(cnt) = pi - 2*atan(abs(FRF_imag_orient(cnt)/FRF_real_orient(cnt)));
    end
end

% Calculate spindle speeds for N = 0 to 3
omega0 = w/(Nt*2*pi)./(0 + epsilon/2/pi);   % rps
omega1 = w/(Nt*2*pi)./(1 + epsilon/2/pi);
omega2 = w/(Nt*2*pi)./(2 + epsilon/2/pi);
omega3 = w/(Nt*2*pi)./(3 + epsilon/2/pi);

figure(2)
subplot(211)
plot(w/2/pi, FRF_real_orient)
axis([0 1000 -7e-4 1e-4])
set(gca,'FontSize', 14)
xlabel('f (Hz)')
ylabel('Real (mm/N)')
subplot(212)
plot(omega0, blim)
axis([0 250 0 6])
set(gca,'FontSize', 14)
xlabel('\Omega (rps)')
ylabel('b_{lim} (mm)')

figure(3)
plot(omega0*60, blim, 'b-', omega1*60, blim, 'b-', omega2*60, blim, 'b-', omega3*60, blim, 'b-')
axis([0 15000 0 6])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('b_{lim} (mm)')
