% p_5_1_1.m
% Copyright
% T. Schmitz
% June 1, 2008

clc
clear all
close all

% Time domain y direction cutting force
% Simulation specifications
kt = 700;                       % tangential cutting coefficient, N/mm^2
kn = 210;                       % normal cutting coefficient, N/mm^2
kte = 0;                        % tangential edge coefficient, N/mm
kne = 0;                        % normal edge coefficient, N/mm
b = 1;                          % axial depth, mm
ft = 0.1;                       % feed per tooth, mm/tooth
phis = 0;                       % cut start angle, deg
phie = 60;                      % cut exit angle, deg
gamma = 30;                     % helix angle, deg
d = 19;                         % cutter diameter, mm
Nt = 4;                         % number of teeth, int
omega = 9000;                   % spindle speed, rpm
steps = 2^12;                   % steps for one cutter revolution, int
dt = 60/(steps*omega);          % time step, s
dphi = 360/steps;               % angular step, deg
if gamma == 0                   % straight teeth
    db = b;                     % discretized axial depth, m
else                            % nonzero helix angle
    db = d*(dphi*pi/180)/2/tan(gamma*pi/180);
end
steps_axial = round(b/db);      % number of steps along tool axis
tooth_angles = 0:360/Nt:(360-360/Nt);  % angles of Nt cutter teeth, deg

% Initialize vectors
teeth = round(tooth_angles/dphi) + 1;
phi = linspace(0, (steps-1)*dphi, steps);
Force_y = zeros(1, steps);

% Main program
for cnt1 = 1:steps              % time steps, s
    for cnt2 = 1:Nt              
   		teeth(cnt2) = teeth(cnt2) + 1;      % index teeth one position (rotate cutter by dphi)
	    if teeth(cnt2) > steps
	      	teeth(cnt2) = 1;
      	end
    end

    Fy = 0;
    for cnt3 = 1:Nt                         % sum forces over all teeth
        for cnt4 = 1:steps_axial            % sum forces along axial depth of helical endmill
            phi_counter = teeth(cnt3) - (cnt4-1);
            if phi_counter < 1              % helix has wrapped through phi = 0 deg
                phi_counter = phi_counter + steps;
            end
            phia = phi(phi_counter);        % angle for given axial disk, deg
            
            if (phia >= phis) & (phia <= phie)          % verify that tooth angle is in specified range for current disk, deg
                h = ft*sin(phia*pi/180);                % chip thickness, m
                Ft = kt*db*h + kte*db;                  % tangential force, N
                Fn = kn*db*h + kne*db;                  % normal force, N
         	else    % tooth angle is outside range bounded by radial immersion
        		Ft = 0;
                Fn = 0;
            end

            Fy = Fy - Fn*cos(phia*pi/180) + Ft*sin(phia*pi/180);    % N
        end     % cnt4 loop
    end         % cnt3 loop
    
    Force_y(cnt1) = Fy;
    t(cnt1) = (cnt1-1)*dt;
end             % cnt1 loop

figure(1)
plot(t, Force_y, 'r')
axis([0 max(t) -10 50])
set(gca,'FontSize', 14)
xlabel('t (s)')
ylabel('F_y (N)')
hold on

% Fourier y direction force representation
dX = 2*db*tan(gamma*pi/180)/d;  % rotation angle for each axial slice, rad

phis = phis*pi/180;             % starting angle, rad
phie = phie*pi/180;             % exit end, rad

% Compute Fourier series coefficients
a0 = (1/(2*pi)*(-1/2*kt*ft*phie+1/4*kt*ft*sin(2*phie)-1/4*kn*ft*cos(2*phie)+kte*cos(phie)+kne*sin(phie))) - (1/(2*pi)*(-1/2*kt*ft*phis+1/4*kt*ft*sin(2*phis)-1/4*kn*ft*cos(2*phis)+kte*cos(phis)+kne*sin(phis)));
a1 = (1/pi*(-1/4*kt*ft*sin(phie)+1/12*kt*ft*sin(3*phie)-1/12*kn*ft*cos(3*phie)-1/4*kn*ft*cos(phie)+1/4*kte*cos(2*phie)+1/4*kne*sin(2*phie)+1/2*kne*phie)) - (1/pi*(-1/4*kt*ft*sin(phis)+1/12*kt*ft*sin(3*phis)-1/12*kn*ft*cos(3*phis)-1/4*kn*ft*cos(phis)+1/4*kte*cos(2*phis)+1/4*kne*sin(2*phis)+1/2*kne*phis));
a2 = (1/pi*(-1/4*kt*ft*sin(2*phie)+1/16*kt*ft*sin(4*phie)+1/4*kt*ft*phie-1/16*kn*ft*cos(4*phie)+1/6*kte*cos(3*phie)-1/2*kte*cos(phie)+1/2*kne*sin(phie)+1/6*kne*sin(3*phie))) - (1/pi*(-1/4*kt*ft*sin(2*phis)+1/16*kt*ft*sin(4*phis)+1/4*kt*ft*phis-1/16*kn*ft*cos(4*phis)+1/6*kte*cos(3*phis)-1/2*kte*cos(phis)+1/2*kne*sin(phis)+1/6*kne*sin(3*phis)));
b1 = (1/pi*(3/4*cos(phie)*kt*ft-1/12*kt*ft*cos(3*phie)+1/4*kn*ft*sin(phie)-1/12*kn*ft*sin(3*phie)-1/2*kte*phie+1/4*kte*sin(2*phie)-1/4*kne*cos(2*phie))) - (1/pi*(3/4*cos(phis)*kt*ft-1/12*kt*ft*cos(3*phis)+1/4*kn*ft*sin(phis)-1/12*kn*ft*sin(3*phis)-1/2*kte*phis+1/4*kte*sin(2*phis)-1/4*kne*cos(2*phis)));
b2 = (1/pi*(1/4*kt*ft*cos(2*phie)-1/16*kt*ft*cos(4*phie)+1/4*kn*ft*phie-1/16*kn*ft*sin(4*phie)-1/2*kte*sin(phie)+1/6*kte*sin(3*phie)-1/6*kne*cos(3*phie)-1/2*kne*cos(phie))) - (1/pi*(1/4*kt*ft*cos(2*phis)-1/16*kt*ft*cos(4*phis)+1/4*kn*ft*phis-1/16*kn*ft*sin(4*phis)-1/2*kte*sin(phis)+1/6*kte*sin(3*phis)-1/6*kne*cos(3*phis)-1/2*kne*cos(phis)));

terms = 5;
for cnt = 3:terms
    % a_n terms
    eval(['a' num2str(cnt) ' = (1/pi*(kt*ft*(-1/2/' num2str(cnt) '*sin(' num2str(cnt) '*phie)+1/4/(' num2str(cnt) '-2)*sin((' num2str(cnt) '-2)*phie)+1/4/(' num2str(cnt) '+2)*sin((' num2str(cnt) '+2)*phie))+kn*ft*(-1/4/(' num2str(cnt) '+2)*cos((' num2str(cnt) '+2)*phie)+1/4/(' num2str(cnt) '-2)*cos((' num2str(cnt) '-2)*phie))+kte*(1/2/(' num2str(cnt) '+1)*cos((' num2str(cnt) '+1)*phie)-1/2/(' num2str(cnt) '-1)*cos((' num2str(cnt) '-1)*phie))+kne*(1/2/(' num2str(cnt) '-1)*sin((' num2str(cnt) '-1)*phie)+1/2/(' num2str(cnt) '+1)*sin((' num2str(cnt) '+1)*phie))));']);
    eval(['a' num2str(cnt) ' = a' num2str(cnt) ' - (1/pi*(kt*ft*(-1/2/' num2str(cnt) '*sin(' num2str(cnt) '*phis)+1/4/(' num2str(cnt) '-2)*sin((' num2str(cnt) '-2)*phis)+1/4/(' num2str(cnt) '+2)*sin((' num2str(cnt) '+2)*phis))+kn*ft*(-1/4/(' num2str(cnt) '+2)*cos((' num2str(cnt) '+2)*phis)+1/4/(' num2str(cnt) '-2)*cos((' num2str(cnt) '-2)*phis))+kte*(1/2/(' num2str(cnt) '+1)*cos((' num2str(cnt) '+1)*phis)-1/2/(' num2str(cnt) '-1)*cos((' num2str(cnt) '-1)*phis))+kne*(1/2/(' num2str(cnt) '-1)*sin((' num2str(cnt) '-1)*phis)+1/2/(' num2str(cnt) '+1)*sin((' num2str(cnt) '+1)*phis))));']);
    % b_n terms
    eval(['b' num2str(cnt) ' = (1/pi*(kt*ft*(1/2/' num2str(cnt) '*cos(' num2str(cnt) '*phie)-1/4/(' num2str(cnt) '-2)*cos((' num2str(cnt) '-2)*phie)-1/4/(' num2str(cnt) '+2)*cos((' num2str(cnt) '+2)*phie))+kn*ft*(-1/4/(' num2str(cnt) '+2)*sin((' num2str(cnt) '+2)*phie)+1/4/(' num2str(cnt) '-2)*sin((' num2str(cnt) '-2)*phie))+kte*(1/2/(' num2str(cnt) '+1)*sin((' num2str(cnt) '+1)*phie)-1/2/(' num2str(cnt) '-1)*sin((' num2str(cnt) '-1)*phie))+kne*(-1/2/(' num2str(cnt) '-1)*cos((' num2str(cnt) '-1)*phie)-1/2/(' num2str(cnt) '+1)*cos((' num2str(cnt) '+1)*phie))));']);
    eval(['b' num2str(cnt) ' = b' num2str(cnt) ' - (1/pi*(kt*ft*(1/2/' num2str(cnt) '*cos(' num2str(cnt) '*phis)-1/4/(' num2str(cnt) '-2)*cos((' num2str(cnt) '-2)*phis)-1/4/(' num2str(cnt) '+2)*cos((' num2str(cnt) '+2)*phis))+kn*ft*(-1/4/(' num2str(cnt) '+2)*sin((' num2str(cnt) '+2)*phis)+1/4/(' num2str(cnt) '-2)*sin((' num2str(cnt) '-2)*phis))+kte*(1/2/(' num2str(cnt) '+1)*sin((' num2str(cnt) '+1)*phis)-1/2/(' num2str(cnt) '-1)*sin((' num2str(cnt) '-1)*phis))+kne*(-1/2/(' num2str(cnt) '-1)*cos((' num2str(cnt) '-1)*phis)-1/2/(' num2str(cnt) '+1)*cos((' num2str(cnt) '+1)*phis))));']);
end

% Sum contributions of all slices (steps_axial) and all teeth (Nt)
w = omega/60*2*pi;      % rotating frequency of tool, rad/s

Fourier_y = zeros(1, length(t));
for cnt1 = 1:steps_axial
    for cnt2 = 1:Nt
        Fourier_y = Fourier_y + -db*a0;
        phi = w*t + 2*pi/Nt*(cnt2-1) - dX*(cnt1-1);    % cutter angle for given axial depth and tooth, rad
        for cnt3 = 1:terms
            eval(['Fourier_y = Fourier_y + -db*(a' num2str(cnt3) '*cos(' num2str(cnt3) '*phi) + b' num2str(cnt3) '*sin(' num2str(cnt3) '*phi));']);
        end
    end
end

plot(t, Fourier_y, 'r:')

terms = 50;
for cnt = 3:terms
    % a_n terms
    eval(['a' num2str(cnt) ' = (1/pi*(kt*ft*(-1/2/' num2str(cnt) '*sin(' num2str(cnt) '*phie)+1/4/(' num2str(cnt) '-2)*sin((' num2str(cnt) '-2)*phie)+1/4/(' num2str(cnt) '+2)*sin((' num2str(cnt) '+2)*phie))+kn*ft*(-1/4/(' num2str(cnt) '+2)*cos((' num2str(cnt) '+2)*phie)+1/4/(' num2str(cnt) '-2)*cos((' num2str(cnt) '-2)*phie))+kte*(1/2/(' num2str(cnt) '+1)*cos((' num2str(cnt) '+1)*phie)-1/2/(' num2str(cnt) '-1)*cos((' num2str(cnt) '-1)*phie))+kne*(1/2/(' num2str(cnt) '-1)*sin((' num2str(cnt) '-1)*phie)+1/2/(' num2str(cnt) '+1)*sin((' num2str(cnt) '+1)*phie))));']);
    eval(['a' num2str(cnt) ' = a' num2str(cnt) ' - (1/pi*(kt*ft*(-1/2/' num2str(cnt) '*sin(' num2str(cnt) '*phis)+1/4/(' num2str(cnt) '-2)*sin((' num2str(cnt) '-2)*phis)+1/4/(' num2str(cnt) '+2)*sin((' num2str(cnt) '+2)*phis))+kn*ft*(-1/4/(' num2str(cnt) '+2)*cos((' num2str(cnt) '+2)*phis)+1/4/(' num2str(cnt) '-2)*cos((' num2str(cnt) '-2)*phis))+kte*(1/2/(' num2str(cnt) '+1)*cos((' num2str(cnt) '+1)*phis)-1/2/(' num2str(cnt) '-1)*cos((' num2str(cnt) '-1)*phis))+kne*(1/2/(' num2str(cnt) '-1)*sin((' num2str(cnt) '-1)*phis)+1/2/(' num2str(cnt) '+1)*sin((' num2str(cnt) '+1)*phis))));']);
    % b_n terms
    eval(['b' num2str(cnt) ' = (1/pi*(kt*ft*(1/2/' num2str(cnt) '*cos(' num2str(cnt) '*phie)-1/4/(' num2str(cnt) '-2)*cos((' num2str(cnt) '-2)*phie)-1/4/(' num2str(cnt) '+2)*cos((' num2str(cnt) '+2)*phie))+kn*ft*(-1/4/(' num2str(cnt) '+2)*sin((' num2str(cnt) '+2)*phie)+1/4/(' num2str(cnt) '-2)*sin((' num2str(cnt) '-2)*phie))+kte*(1/2/(' num2str(cnt) '+1)*sin((' num2str(cnt) '+1)*phie)-1/2/(' num2str(cnt) '-1)*sin((' num2str(cnt) '-1)*phie))+kne*(-1/2/(' num2str(cnt) '-1)*cos((' num2str(cnt) '-1)*phie)-1/2/(' num2str(cnt) '+1)*cos((' num2str(cnt) '+1)*phie))));']);
    eval(['b' num2str(cnt) ' = b' num2str(cnt) ' - (1/pi*(kt*ft*(1/2/' num2str(cnt) '*cos(' num2str(cnt) '*phis)-1/4/(' num2str(cnt) '-2)*cos((' num2str(cnt) '-2)*phis)-1/4/(' num2str(cnt) '+2)*cos((' num2str(cnt) '+2)*phis))+kn*ft*(-1/4/(' num2str(cnt) '+2)*sin((' num2str(cnt) '+2)*phis)+1/4/(' num2str(cnt) '-2)*sin((' num2str(cnt) '-2)*phis))+kte*(1/2/(' num2str(cnt) '+1)*sin((' num2str(cnt) '+1)*phis)-1/2/(' num2str(cnt) '-1)*sin((' num2str(cnt) '-1)*phis))+kne*(-1/2/(' num2str(cnt) '-1)*cos((' num2str(cnt) '-1)*phis)-1/2/(' num2str(cnt) '+1)*cos((' num2str(cnt) '+1)*phis))));']);
end

% Sum contributions of all slices (steps_axial) and all teeth (Nt)
Fourier_y = zeros(1, length(t));
for cnt1 = 1:steps_axial
    for cnt2 = 1:Nt
        Fourier_y = Fourier_y + -db*a0;
        phi = w*t + 2*pi/Nt*(cnt2-1) - dX*(cnt1-1);    % cutter angle for given axial depth and tooth, rad
        for cnt3 = 1:terms
            eval(['Fourier_y = Fourier_y + -db*(a' num2str(cnt3) '*cos(' num2str(cnt3) '*phi) + b' num2str(cnt3) '*sin(' num2str(cnt3) '*phi));']);
        end
    end
end

plot(t, Fourier_y, 'b--')
