% p_5_2_1.m
% Copyright
% T. Schmitz
% June 1, 2008

clc
close all
clear all

% Variables
% Specific cutting force values
kt = 700e6;                     % tangential cutting force coefficient, N/m^2
kn = 210e6;                     % radial cutting force coefficient, N/m^2
kte = 0e3;                      % tangential edge constant, N/m
kne = 0e3;                      % radial edge constant, N/m

% Tool description
ky = [1e7];                     % N/m
zetay = [0.01];
wny = [500]*2*pi;               % rad/s
my = ky./(wny.^2);              % kg
cy = 2*zetay.*(my.*ky).^0.5;    % N-s/m

Nt = 4;                         % teeth, integer
gamma = 30;                     % helix angle, deg
d = 12.7e-3;                    % teeth diameter, m

% Machining specifications
% Down milling
phis = 90;                      % starting angle, deg
phie = 180;                     % exit angle, deg
b = 1e-3;                       % axial depth of cut, m
ft = 0.1e-3;                    % feed/tooth, m
ss = 6900:5:7800;               % spindle speeds, rpm

% Define y-direction FRF
f = 0:0.1:(2*max(wny)/2/pi);    % Hz
w = f*2*pi;                     % rad/s
FRFy = (wny(1)^2/ky(1))./(wny(1)^2 - w.^2 + i*2*zetay(1)*wny(1).*w);
for cnt = 2:length(ky)
    FRFy = FRFy + (wny(cnt)^2/ky(cnt))./(wny(cnt)^2 - w.^2 + i*2*zetay(cnt)*wny(cnt).*w);
end

for cnt = 1:length(ss)
    omega = ss(cnt);
    [e] = p_5_2_2(f, FRFy, kt, kn, kte, kne, Nt, gamma, d, phis*pi/180, phie*pi/180, omega, b, ft);
    error(cnt) = e*1e6;
end

figure(1)
plot(ss, error, 'ro')
set(gca,'FontSize', 14)
axis([min(ss) max(ss) -150 165])
xlabel('\Omega (rpm)')
ylabel('SLE (\mum)')
hold on

clear all

% Variables
% Specific cutting force values
kt = 700e6;                     % tangential cutting force coefficient, N/m^2
kn = 210e6;                     % radial cutting force coefficient, N/m^2
kte = 0e3;                      % tangential edge constant, N/m
kne = 0e3;                      % radial edge constant, N/m

% Tool description
ky = [1e7];                     % N/m
zetay = [0.01];
wny = [500]*2*pi;               % rad/s
my = ky./(wny.^2);              % kg
cy = 2*zetay.*(my.*ky).^0.5;    % N-s/m

Nt = 4;                         % teeth, integer
gamma = 30;                     % helix angle, deg
d = 12.7e-3;                    % teeth diameter, m

% Up milling
phis = 0;                       % starting angle, deg
phie = 90;                      % exit angle, deg
b = 1e-3;                       % axial depth of cut, m
ft = 0.1e-3;                    % feed/tooth, m
ss = 6900:5:7800;               % spindle speeds, rpm

% Define y-direction FRF
f = 0:0.1:(2*max(wny)/2/pi);    % Hz
w = f*2*pi;                     % rad/s
FRFy = (wny(1)^2/ky(1))./(wny(1)^2 - w.^2 + i*2*zetay(1)*wny(1).*w);
for cnt = 2:length(ky)
    FRFy = FRFy + (wny(cnt)^2/ky(cnt))./(wny(cnt)^2 - w.^2 + i*2*zetay(cnt)*wny(cnt).*w);
end

for cnt = 1:length(ss)
    omega = ss(cnt);
    [e] = p_5_2_2(f, FRFy, kt, kn, kte, kne, Nt, gamma, d, phis*pi/180, phie*pi/180, omega, b, ft);
    error(cnt) = e*1e6;
end

plot(ss, error, 'b+')
