% p_5_2_3.m
% Copyright
% T. Schmitz
% June 1, 2008

clc
clear
close all

% Fourier series approach
% Define parameters for x direction
kx = 1e7;               % N/m
wnx = 500*2*pi;         % rad/s
zetax = 0.01;

% Define parameters for y direction
ky = 1e7;               % N/m
wny = 500*2*pi;         % rad/s
zetay = 0.01;

phis = 0*pi/180;        % rad
phie = 90*pi/180;       % rad

% Cutting force coefficients
Kt = 700e6;             % N/m^2
Kn = 210e6/700e6;
Nt = 4;

alphaxx = 0.5*((cos(2*phie)-2*Kn*phie+Kn*sin(2*phie))-(cos(2*phis)-2*Kn*phis+Kn*sin(2*phis)));
alphaxy = 0.5*((-sin(2*phie)-2*phie+Kn*cos(2*phie))-(-sin(2*phis)-2*phis+Kn*cos(2*phis)));
alphayx = 0.5*((-sin(2*phie)+2*phie+Kn*cos(2*phie))-(-sin(2*phis)+2*phis+Kn*cos(2*phis)));
alphayy = 0.5*((-cos(2*phie)-2*Kn*phie-Kn*sin(2*phie))-(-cos(2*phis)-2*Kn*phis-Kn*sin(2*phis)));

wnmax = max([wnx wny]);
w = (0:0.1:2*wnmax/2/pi)'*2*pi;   % frequency, rad/s
FRFxx = (wnx^2/kx)./(wnx^2 - w.^2 + 1i*2*zetax*wnx.*w);
FRFyy = (wny^2/ky)./(wny^2 - w.^2 + 1i*2*zetay*wny.*w);

for cnt = 1:length(w)
    % Oriented FRF
    FRF_or = [alphaxx*FRFxx(cnt) alphaxy*FRFyy(cnt); alphayx*FRFxx(cnt) alphayy*FRFyy(cnt)];    % m/N
    % Calculate two eigenvalues
    E = eig(FRF_or);
    temp = E(1);
    lambda1(cnt) = temp;
    temp = E(2);
    lambda2(cnt) = temp;
    if (cnt > 1)
        dot_prod1 = real(lambda2(cnt))*real(lambda2(cnt-1)) + imag(lambda2(cnt))*imag(lambda2(cnt-1));
        dot_prod2 = real(lambda2(cnt))*real(lambda1(cnt-1)) + imag(lambda2(cnt))*imag(lambda1(cnt-1));
        if (dot_prod2 > dot_prod1)
            temp = lambda2(cnt);
            lambda2(cnt) = lambda1(cnt);
            lambda1(cnt) = temp;
        end
    end
end

lambda1 = lambda1';
lambda2 = lambda2';

blim1 = (2*pi/Nt/Kt)./((real(lambda1)).^2 + (imag(lambda1)).^2) .* (real(lambda1) .* (1 + (imag(lambda1)./real(lambda1)).^2));  % m
blim2 = (2*pi/Nt/Kt)./((real(lambda2)).^2 + (imag(lambda2)).^2) .* (real(lambda2) .* (1 + (imag(lambda2)./real(lambda2)).^2));

[index1] = find(blim1 > 0);
blim1 = blim1(index1);
blim1 = blim1*1e3;      % mm
w1 = w(index1);
psi1 = atan2(imag(lambda1), real(lambda1));
psi1 = psi1(index1);
epsilon1 = pi - 2*psi1;
omega11 = (60/Nt)*w1./(epsilon1 + 2*0*pi);     % rpm
omega12 = (60/Nt)*w1./(epsilon1 + 2*1*pi);
omega13 = (60/Nt)*w1./(epsilon1 + 2*2*pi);
omega14 = (60/Nt)*w1./(epsilon1 + 2*3*pi);
omega15 = (60/Nt)*w1./(epsilon1 + 2*4*pi);

[index2] = find(blim2 > 0);
blim2 = blim2(index2);
blim2 = blim2*1e3;
w2 = w(index2);
psi2 = atan2(imag(lambda2), real(lambda2));
psi2 = psi2(index2);
epsilon2 = pi - 2*psi2;
omega21 = (60/Nt)*w2./(epsilon2 + 2*0*pi);
omega22 = (60/Nt)*w2./(epsilon2 + 2*1*pi);
omega23 = (60/Nt)*w2./(epsilon2 + 2*2*pi);
omega24 = (60/Nt)*w2./(epsilon2 + 2*3*pi);
omega25 = (60/Nt)*w2./(epsilon2 + 2*4*pi);

figure(1)
% First eigenvalue
plot(omega11, blim1, 'b', omega12, blim1, 'b', omega13, blim1, 'b', omega14, blim1, 'b', omega15, blim1, 'b')
hold on
% Second eigenvalue
plot(omega21, blim2, 'r', omega22, blim2, 'r', omega23, blim2, 'r', omega24, blim2, 'r', omega25, blim2, 'r')
axis([2800 10000 0 6])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('b_{lim} (mm)')
