% p_5_2_4.m
% Copyright
% T. Schmitz
% June 1, 2008

clc
close all
clear

% Variables
% Specific cutting force values
kt = 700e6;                     % tangential cutting force coefficient, N/m^2
kn = 210e6;                     % radial cutting force coefficient, N/m^2
kte = 0e3;                      % tangential edge constant, N/m
kne = 0e3;                      % radial edge constant, N/m

% Tool description
ky = [1e7];                     % N/m
zetay = [0.01];
wny = [500]*2*pi;               % rad/s
my = ky./(wny.^2);              % kg
cy = 2*zetay.*(my.*ky).^0.5;    % N-s/m

% Tool description
Nt = 4;                         % teeth, integer
gamma = 30;                     % helix angle, deg
d = 12.7e-3;                    % teeth diameter, m

% Machining specifications
% Up milling
phis = 0;                       % starting angle, deg
phie = 90;                      % exit angle, deg
ft = 0.1e-3;                    % feed/tooth, m
axial_depth = 0.5e-3:0.05e-3:5e-3;  % axial depths of cut, m
ss = 6900:10:7700;              % spindle speeds, rpm

% Define y direction FRF
f = 0:0.1:(2*max(wny)/2/pi);    % Hz
w = f*2*pi;                     % rad/s
FRFy = (wny(1)^2/ky(1))./(wny(1)^2 - w.^2 + 1i*2*zetay(1)*wny(1).*w);
for cnt = 2:length(ky)
    FRFy = FRFy + (wny(cnt)^2/ky(cnt))./(wny(cnt)^2 - w.^2 + 1i*2*zetay(cnt)*wny(cnt).*w);
end

for row = 1:length(axial_depth)
    b = axial_depth(row);
    for col = 1:length(ss)
        omega = ss(col);
        [e] = p_5_2_2(f, FRFy, kt, kn, kte, kne, Nt, gamma, d, phis*pi/180, phie*pi/180, omega, b, ft);
        error(row, col) = e*1e6;
    end
end

figure(1)
[cs, h] = contourf(ss, axial_depth*1e3, error);
colormap(gray)
set(gca,'FontSize', 14)
axis([min(ss) max(ss) min(axial_depth)*1e3 max(axial_depth)*1e3])
xlabel('\Omega (rpm)')
ylabel('b (mm)')
colorbar
clabel(cs, h, [0 200 400], 'FontSize', 14, 'Color', 'b', 'Rotation', 0, 'LabelSpacing', 200)
