% p_5_2_7.m
% Copyright
% T. Schmitz
% June 1, 2008

clc
close all
clear

% Variables
% Specific cutting force values
kt = 700e6;                     % tangential cutting force coefficient, N/m^2
kn = 210e6;                     % radial cutting force coefficient, N/m^2
kte = 0e3;                      % tangential edge constant, N/m
kne = 0e3;                      % radial edge constant, N/m

% Tool description
ky = [1e7];                     % N/m
zetay = [0.01];
wny = [500]*2*pi;               % rad/s
my = ky./(wny.^2);              % kg
cy = 2*zetay.*(my.*ky).^0.5;    % N-s/m

Nt = 4;                         % teeth, integer
gamma = 30;                     % helix angle, deg
d = 12.7e-3;                    % teeth diameter, m

% Machining specifications
phie = 180;                     % exit angle, deg
b = 0.35e-3;                    % axial depth of cut, m
ft = 0.1e-3;                    % feed/tooth, m
ss = 6900:5:7800;               % spindle speeds, rpm

% Define y direction FRF
f = 0:0.1:(2*max(wny)/2/pi);    % Hz
w = f*2*pi;                     % rad/s
FRFy = (wny(1)^2/ky(1))./(wny(1)^2 - w.^2 + 1i*2*zetay(1)*wny(1).*w);
for cnt = 2:length(ky)
    FRFy = FRFy + (wny(cnt)^2/ky(cnt))./(wny(cnt)^2 - w.^2 + 1i*2*zetay(cnt)*wny(cnt).*w);
end

% Starting angle, deg
phistart = [90 101.5 113.6 126.9];

for row = 1:length(phistart)
    row
    for col = 1:length(ss)
        phis = phistart(row);
        omega = ss(col);
        [e] = p_5_2_2(f, FRFy, kt, kn, kte, kne, Nt, gamma, d, phis*pi/180, phie*pi/180, omega, b, ft);
        error(row, col) = e*1e6;
    end
end

figure(1)
for row = 1:length(phistart)
    plot(ss, error(row, :))
    hold on
end
set(gca,'FontSize', 14)
axis([min(ss) max(ss) -60 40])
xlabel('\Omega (rpm)')
ylabel('SLE (\mum)')
