% p_5_2_8.m
% Copyright
% T. Schmitz
% June 1, 2008

clc
close all
clear

% Variables
% Specific cutting force values
kt = 700e6;                     % tangential cutting force coefficient, N/m^2
kn = 210e6;                     % radial cutting force coefficient, N/m^2
kte = 0e3;                      % tangential edge constant, N/m
kne = 0e3;                      % radial edge constant, N/m

% Tool description
ky = [1e7];                     % N/m
zetay = [0.01];
wny = [500]*2*pi;               % rad/s
my = ky./(wny.^2);              % kg
cy = 2*zetay.*(my.*ky).^0.5;    % N-s/m

Nt = 4;                         % teeth, integer
d = 12.7e-3;                    % teeth diameter, m
gamma = 30;                     % helix angle, deg

% Machining specifications
phis = 0;                       % starting angle, deg
phie = 90;                      % exit angle, deg

% Consider only up and down milling cases
if phis == 0
    flag = 0;   % up milling
else
    flag = 180; % down milling
end

omega = 7500;                   % spindle speed, rpm
b = 12e-3;                      % axial depth of cut, m
ft = 0.1e-3;                    % feed/tooth, m
steps_rev = 2000;               % number of time steps per revolution of cutter (for dt calculation)
steps_axial = 120;              % number of steps along tool axis
db = b/steps_axial;             % axial height of each slice, m
dX = 2*db*tan(gamma*pi/180)/d;  % delay angle for each axial slice, rad

phis = phis*pi/180;             % starting angle, rad
phie = phie*pi/180;             % exit angle, rad

% Compute Fourier series coefficients
a0 = (1/(2*pi)*(-1/2*kt*ft*phie+1/4*kt*ft*sin(2*phie)-1/4*kn*ft*cos(2*phie)+kte*cos(phie)+kne*sin(phie))) - (1/(2*pi)*(-1/2*kt*ft*phis+1/4*kt*ft*sin(2*phis)-1/4*kn*ft*cos(2*phis)+kte*cos(phis)+kne*sin(phis)));
a1 = (1/pi*(-1/4*kt*ft*sin(phie)+1/12*kt*ft*sin(3*phie)-1/12*kn*ft*cos(3*phie)-1/4*kn*ft*cos(phie)+1/4*kte*cos(2*phie)+1/4*kne*sin(2*phie)+1/2*kne*phie)) - (1/pi*(-1/4*kt*ft*sin(phis)+1/12*kt*ft*sin(3*phis)-1/12*kn*ft*cos(3*phis)-1/4*kn*ft*cos(phis)+1/4*kte*cos(2*phis)+1/4*kne*sin(2*phis)+1/2*kne*phis));
a2 = (1/pi*(-1/4*kt*ft*sin(2*phie)+1/16*kt*ft*sin(4*phie)+1/4*kt*ft*phie-1/16*kn*ft*cos(4*phie)+1/6*kte*cos(3*phie)-1/2*kte*cos(phie)+1/2*kne*sin(phie)+1/6*kne*sin(3*phie))) - (1/pi*(-1/4*kt*ft*sin(2*phis)+1/16*kt*ft*sin(4*phis)+1/4*kt*ft*phis-1/16*kn*ft*cos(4*phis)+1/6*kte*cos(3*phis)-1/2*kte*cos(phis)+1/2*kne*sin(phis)+1/6*kne*sin(3*phis)));
b1 = (1/pi*(3/4*cos(phie)*kt*ft-1/12*kt*ft*cos(3*phie)+1/4*kn*ft*sin(phie)-1/12*kn*ft*sin(3*phie)-1/2*kte*phie+1/4*kte*sin(2*phie)-1/4*kne*cos(2*phie))) - (1/pi*(3/4*cos(phis)*kt*ft-1/12*kt*ft*cos(3*phis)+1/4*kn*ft*sin(phis)-1/12*kn*ft*sin(3*phis)-1/2*kte*phis+1/4*kte*sin(2*phis)-1/4*kne*cos(2*phis)));
b2 = (1/pi*(1/4*kt*ft*cos(2*phie)-1/16*kt*ft*cos(4*phie)+1/4*kn*ft*phie-1/16*kn*ft*sin(4*phie)-1/2*kte*sin(phie)+1/6*kte*sin(3*phie)-1/6*kne*cos(3*phie)-1/2*kne*cos(phie))) - (1/pi*(1/4*kt*ft*cos(2*phis)-1/16*kt*ft*cos(4*phis)+1/4*kn*ft*phis-1/16*kn*ft*sin(4*phis)-1/2*kte*sin(phis)+1/6*kte*sin(3*phis)-1/6*kne*cos(3*phis)-1/2*kne*cos(phis)));

terms = 25;
for cnt = 3:terms
    % a_n terms
    eval(['a' num2str(cnt) ' = (1/pi*(kt*ft*(-1/2/' num2str(cnt) '*sin(' num2str(cnt) '*phie)+1/4/(' num2str(cnt) '-2)*sin((' num2str(cnt) '-2)*phie)+1/4/(' num2str(cnt) '+2)*sin((' num2str(cnt) '+2)*phie))+kn*ft*(-1/4/(' num2str(cnt) '+2)*cos((' num2str(cnt) '+2)*phie)+1/4/(' num2str(cnt) '-2)*cos((' num2str(cnt) '-2)*phie))+kte*(1/2/(' num2str(cnt) '+1)*cos((' num2str(cnt) '+1)*phie)-1/2/(' num2str(cnt) '-1)*cos((' num2str(cnt) '-1)*phie))+kne*(1/2/(' num2str(cnt) '-1)*sin((' num2str(cnt) '-1)*phie)+1/2/(' num2str(cnt) '+1)*sin((' num2str(cnt) '+1)*phie))));']);
    eval(['a' num2str(cnt) ' = a' num2str(cnt) ' - (1/pi*(kt*ft*(-1/2/' num2str(cnt) '*sin(' num2str(cnt) '*phis)+1/4/(' num2str(cnt) '-2)*sin((' num2str(cnt) '-2)*phis)+1/4/(' num2str(cnt) '+2)*sin((' num2str(cnt) '+2)*phis))+kn*ft*(-1/4/(' num2str(cnt) '+2)*cos((' num2str(cnt) '+2)*phis)+1/4/(' num2str(cnt) '-2)*cos((' num2str(cnt) '-2)*phis))+kte*(1/2/(' num2str(cnt) '+1)*cos((' num2str(cnt) '+1)*phis)-1/2/(' num2str(cnt) '-1)*cos((' num2str(cnt) '-1)*phis))+kne*(1/2/(' num2str(cnt) '-1)*sin((' num2str(cnt) '-1)*phis)+1/2/(' num2str(cnt) '+1)*sin((' num2str(cnt) '+1)*phis))));']);
    % b_n terms
    eval(['b' num2str(cnt) ' = (1/pi*(kt*ft*(1/2/' num2str(cnt) '*cos(' num2str(cnt) '*phie)-1/4/(' num2str(cnt) '-2)*cos((' num2str(cnt) '-2)*phie)-1/4/(' num2str(cnt) '+2)*cos((' num2str(cnt) '+2)*phie))+kn*ft*(-1/4/(' num2str(cnt) '+2)*sin((' num2str(cnt) '+2)*phie)+1/4/(' num2str(cnt) '-2)*sin((' num2str(cnt) '-2)*phie))+kte*(1/2/(' num2str(cnt) '+1)*sin((' num2str(cnt) '+1)*phie)-1/2/(' num2str(cnt) '-1)*sin((' num2str(cnt) '-1)*phie))+kne*(-1/2/(' num2str(cnt) '-1)*cos((' num2str(cnt) '-1)*phie)-1/2/(' num2str(cnt) '+1)*cos((' num2str(cnt) '+1)*phie))));']);
    eval(['b' num2str(cnt) ' = b' num2str(cnt) ' - (1/pi*(kt*ft*(1/2/' num2str(cnt) '*cos(' num2str(cnt) '*phis)-1/4/(' num2str(cnt) '-2)*cos((' num2str(cnt) '-2)*phis)-1/4/(' num2str(cnt) '+2)*cos((' num2str(cnt) '+2)*phis))+kn*ft*(-1/4/(' num2str(cnt) '+2)*sin((' num2str(cnt) '+2)*phis)+1/4/(' num2str(cnt) '-2)*sin((' num2str(cnt) '-2)*phis))+kte*(1/2/(' num2str(cnt) '+1)*sin((' num2str(cnt) '+1)*phis)-1/2/(' num2str(cnt) '-1)*sin((' num2str(cnt) '-1)*phis))+kne*(-1/2/(' num2str(cnt) '-1)*cos((' num2str(cnt) '-1)*phis)-1/2/(' num2str(cnt) '+1)*cos((' num2str(cnt) '+1)*phis))));']);
end

n = 16;
points = 2^n;

% Sum contributions of all slices (steps_axial) and all teeth (Nt)
w = omega/60*2*pi;      % rotating frequency of tool, rad/s

% Define time vector
dt = 60/(steps_rev*omega);
time = (1:points)*dt - dt;

Fourier_y = zeros(1, length(time));
for cnt1 = 1:steps_axial
    for cnt2 = 1:Nt
        Fourier_y = Fourier_y + -db*a0;
        phi = w*time + 2*pi/Nt*(cnt2-1) - dX*(cnt1-1);    % cutter angle for given axial depth and tooth, rad
        for cnt3 = 1:terms
            eval(['Fourier_y = Fourier_y + -db*(a' num2str(cnt3) '*cos(' num2str(cnt3) '*phi) + b' num2str(cnt3) '*sin(' num2str(cnt3) '*phi));']);
        end
    end
end

% Compute FFT of Fourier-based y direction force
fs = 1/dt;
N = length(Fourier_y);
FY = fft(Fourier_y');
FY = FY(1:N/2+1);
freq = [0:fs/N:(1-1/(2*N))*fs]';
freq = freq(1:N/2+1);           % frequency, Hz

% Define y direction FRF
w = freq*2*pi;
FRFy = (wny(1)^2/ky(1))./(wny(1)^2 - w.^2 + 1i*2*zetay(1)*wny(1).*w);
for cnt = 2:length(ky)
    FRFy = FRFy + (wny(cnt)^2/ky(cnt))./(wny(cnt)^2 - w.^2 + 1i*2*zetay(cnt)*wny(cnt).*w);
end

Y = FY.*FRFy;                   % compute y deflection in frequency domain
y = real(ifft(Y));              % convert to time domain
t = 0:2*dt:(length(y)-1)*2*dt;  % new time vector after inverse FFT

% Use automatic method to sample y
for cnt = 1:steps_axial
    cnt
    tfirst = (flag*pi/180 + dX*(cnt-1))/(omega/60*2*pi);   % time for first SLE point, s
    T = 2*pi/Nt/(omega/60*2*pi);            % tooth passing period, s
    resolution = 1000;                      % number of points in period, user-selected
    dt_new = T/resolution;                  % new time increment, s
    tnew = 0:dt_new:max(t);                 % time vector, s
    ynew = interp1(t, y, tnew);             % y direction vibration in time domain, m
    index = find(tnew > tfirst);            
    first_point = index(1) - 1;             % first point for SLE
    ratio = round(dt/dt_new);               % ratio of time increment to new time increment
    index = first_point:resolution:length(tnew);    % points where SLE will be determined
    index = index - ratio;                  % correct index to account for sampling frequency ratio
    index(1) = first_point;                 % correct first point in index to avoid zero or negative value
    y_Fourier_sampled = ynew(index);        % sampled position vector -- SLE values
    sle(cnt) = y_Fourier_sampled(length(y_Fourier_sampled))*1e6;   % record SLE, micrometers
end

figure(1)
axial_depth = (1:steps_axial)*db - db;
plot(sle, axial_depth*1e3)
set(gca,'FontSize', 14)
xlabel('SLE (\mum)')
ylabel('|z| (mm)')
xlim([-450 800])
