% p_6_2_1.m
% Copyright
% T. Schmitz
% June 1, 2008

clear
close all
clc

% Define parameters for x direction
kx1 = 5e6;              % N/m
wnx1 = 800*2*pi;        % rad/s
zetax1 = 0.01;

kx2 = 9e6;              % N/m
wnx2 = 900*2*pi;        % rad/s
zetax2 = 0.02;

% Define parameters for y direction
ky1 = 5e6;              % N/m
wny1 = 800*2*pi;        % rad/s
zetay1 = 0.01;

ky2 = 9e6;              % N/m
wny2 = 900*2*pi;        % rad/s
zetay2 = 0.02;

% Define specific force and force angle
Ks = 700;               % N/mm^2
beta = 66;              % deg

% Define FRFs for two directions
w = (0:0.1:1500*2*pi);  % frequency, rad/s
rx1 = w/wnx1;
rx2 = w/wnx2;
FRF_real_x = 1/kx1*(1-rx1.^2)./((1-rx1.^2).^2 + (2*zetax1*rx1).^2) + 1/kx2*(1-rx2.^2)./((1-rx2.^2).^2 + (2*zetax2*rx2).^2);
FRF_imag_x = 1/kx1*(-2*zetax1*rx1)./((1-rx1.^2).^2 + (2*zetax1*rx1).^2) + 1/kx2*(-2*zetax2*rx2)./((1-rx2.^2).^2 + (2*zetax2*rx2).^2);

ry1 = w/wny1;
ry2 = w/wny2;
FRF_real_y = 1/ky1*(1-ry1.^2)./((1-ry1.^2).^2 + (2*zetay1*ry1).^2) + 1/ky2*(1-ry2.^2)./((1-ry2.^2).^2 + (2*zetay2*ry2).^2);
FRF_imag_y = 1/ky1*(-2*zetay1*ry1)./((1-ry1.^2).^2 + (2*zetay1*ry1).^2) + 1/ky2*(-2*zetay2*ry2)./((1-ry2.^2).^2 + (2*zetay2*ry2).^2);

% Convert to mm/N
FRF_real_x = FRF_real_x*1e3;
FRF_imag_x = FRF_imag_x*1e3;
FRF_real_y = FRF_real_y*1e3;
FRF_imag_y = FRF_imag_y*1e3;

% Directional orientation factors
mux = cos((beta-60)*pi/180)*cos(60*pi/180);
muy = cos((150-beta)*pi/180)*cos(150*pi/180);

% Oriented FRF
FRF_real_orient = mux*FRF_real_x + muy*FRF_real_y; 
FRF_imag_orient = mux*FRF_imag_x + muy*FRF_imag_y;

figure(1)
subplot(211)
plot(w/2/pi, FRF_real_orient)
axis([0 1500 -2.2e-3 2.7e-3])
set(gca,'FontSize', 14)
ylabel('Real (mm/N)')
subplot(212)
plot(w/2/pi, FRF_imag_orient)
axis([0 1500 -4.5e-3 5e-4])
set(gca,'FontSize', 14)
xlabel('f (Hz)')
ylabel('Imag (mm/N)')

% Determine valid chatter frequency range
index = find(FRF_real_orient < 0);
FRF_real_orient = FRF_real_orient(index);
FRF_imag_orient = FRF_imag_orient(index);
w = w(index);

% Define average number of teeth in cut, Nt_star
Nt = 4;
phis = 0;       % deg
phie = 60;
Nt_star = (phie - phis)*Nt/360;

% Calculate blim
blim = -1./(2*Ks*FRF_real_orient*Nt_star);  % mm

% Calculate epsilon
epsilon = zeros(1, length(FRF_imag_orient));
for cnt = 1:length(FRF_imag_orient)
    if FRF_imag_orient(cnt) < 0
        epsilon(cnt) = 2*pi - 2*atan(abs(FRF_real_orient(cnt)/FRF_imag_orient(cnt)));
    else
        epsilon(cnt) = pi - 2*atan(abs(FRF_imag_orient(cnt)/FRF_real_orient(cnt)));
    end
end

% Calculate spindle speeds for N = 0 to 4
omega0 = w/(Nt*2*pi)./(0 + epsilon/2/pi);   % rps
omega1 = w/(Nt*2*pi)./(1 + epsilon/2/pi);
omega2 = w/(Nt*2*pi)./(2 + epsilon/2/pi);
omega3 = w/(Nt*2*pi)./(3 + epsilon/2/pi);
omega4 = w/(Nt*2*pi)./(4 + epsilon/2/pi);

% Calculate tooth passing frequency and harmonics
omega_generic = 0:max(omega0)*60;
ftooth0 = omega_generic*Nt/60;              % Hz
ftooth1 = 2*omega_generic*Nt/60;
ftooth2 = 3*omega_generic*Nt/60;
ftooth3 = 4*omega_generic*Nt/60;
ftooth4 = 5*omega_generic*Nt/60;

figure(2)
subplot(211)
plot(w/2/pi, FRF_real_orient)
axis([700 1500 -2.2e-3 2.2e-4])
set(gca,'FontSize', 14)
xlabel('f (Hz)')
ylabel('Real (mm/N)')
subplot(212)
plot(omega0, blim)
axis([175 375 0 3])
set(gca,'FontSize', 14)
xlabel('\Omega (rps)')
ylabel('b_{lim} (mm)')

figure(3)
subplot(211)
plot(omega0*60, blim, 'b-', omega1*60, blim, 'b-', omega2*60, blim, 'b-', omega3*60, blim, 'b-', omega4*60, blim, 'b-')
axis([0 21000 0 3])
set(gca,'FontSize', 14)
ylabel('b_{lim} (mm)')
grid
hold on
plot([12060], [2], 'bo')
subplot(212)
plot(omega0*60, w/2/pi, 'b-', omega1*60, w/2/pi, 'b-', omega2*60, w/2/pi, 'b-', omega3*60, w/2/pi, 'b-', omega4*60, w/2/pi, 'b-')
axis([0 21000 0 1500])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('f_c (Hz)')
hold on
plot(omega_generic, ftooth0, 'r:', omega_generic, ftooth1, 'r:', omega_generic, ftooth2, 'r:', omega_generic, ftooth3, 'r:', omega_generic, ftooth4, 'r:')
grid
plot([12060], [804], 'ro')

figure(4)
subplot(211)
plot(omega0*60, blim, 'b-', omega1*60, blim, 'b-', omega2*60, blim, 'b-', omega3*60, blim, 'b-', omega4*60, blim, 'b-')
axis([0 21000 0 3])
set(gca,'FontSize', 14)
ylabel('b_{lim} (mm)')
grid
hold on
plot([12060], [2], 'bo')
subplot(212)
plot(omega0*60, epsilon*180/pi, 'b-', omega1*60, epsilon*180/pi, 'b-', omega2*60, epsilon*180/pi, 'b-', omega3*60, epsilon*180/pi, 'b-', omega4*60, epsilon*180/pi, 'b-')
axis([0 21000 180 360])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('\epsilon (deg)')
grid
hold on
plot([12060], [358], 'bo')
