% p_6_4_1.m
% Copyright
% T. Schmitz
% June 1, 2008

clear
close all
clc

% Define parameters for x direction
kx = 5e6;               % N/m
wnx = 800*2*pi;         % rad/s
zetax = 0.01;

% Define specific force and force angle
Ks = 2000;              % N/mm^2
beta = 72;              % deg

% Define FRF for x direction
w = (0:0.1:1500*2*pi);  % frequency, rad/s
rx = w/wnx;
FRF_real_x = 1/kx*(1-rx.^2)./((1-rx.^2).^2 + (2*zetax*rx).^2);
FRF_imag_x = 1/kx*(-2*zetax*rx)./((1-rx.^2).^2 + (2*zetax*rx).^2);

% Convert to mm/N
FRF_real_x = FRF_real_x*1e3;
FRF_imag_x = FRF_imag_x*1e3;

% Directional orientation factor
mux = cos((beta-45)*pi/180)*cos(45*pi/180);

% Oriented FRF
FRF_real_orient = mux*FRF_real_x; 
FRF_imag_orient = mux*FRF_imag_x;

% Determine valid chatter frequency range
index = find(FRF_real_orient < 0);
FRF_real_orient = FRF_real_orient(index);
FRF_imag_orient = FRF_imag_orient(index);
w = w(index);

% Define average number of teeth in cut, Nt_star
Nt = 4;
phis = 0;       % deg
phie = 90;
Nt_star = (phie - phis)*Nt/360;

% Calculate blim
blim = -1./(2*Ks*FRF_real_orient*Nt_star);  % mm

% Calculate epsilon
epsilon = zeros(1, length(FRF_imag_orient));
for cnt = 1:length(FRF_imag_orient)
    if FRF_imag_orient(cnt) < 0
        epsilon(cnt) = 2*pi - 2*atan(abs(FRF_real_orient(cnt)/FRF_imag_orient(cnt)));
    else
        epsilon(cnt) = pi - 2*atan(abs(FRF_imag_orient(cnt)/FRF_real_orient(cnt)));
    end
end

% Calculate spindle speeds for N = 0 to 4
omega0 = w/(Nt*2*pi)./(0 + epsilon/2/pi);   % rps
omega1 = w/(Nt*2*pi)./(1 + epsilon/2/pi);
omega2 = w/(Nt*2*pi)./(2 + epsilon/2/pi);
omega3 = w/(Nt*2*pi)./(3 + epsilon/2/pi);
omega4 = w/(Nt*2*pi)./(4 + epsilon/2/pi);

% Calculate tooth passing frequency and harmonics
omega_generic = 0:max(omega0)*60;
ftooth0 = omega_generic*Nt/60;              % Hz
ftooth1 = 2*omega_generic*Nt/60;
ftooth2 = 3*omega_generic*Nt/60;
ftooth3 = 4*omega_generic*Nt/60;
ftooth4 = 5*omega_generic*Nt/60;

% Calculate runout frequency and harmonics
fro0 = omega_generic/60;                    % Hz
fro1 = 2*omega_generic/60;
fro2 = 3*omega_generic/60;
fro3 = 4*omega_generic/60;

figure(1)
subplot(211)
plot(omega0*60, blim, 'b-', omega1*60, blim, 'b-', omega2*60, blim, 'b-', omega3*60, blim, 'b-', omega4*60, blim, 'b-')
axis([0 30000 0 3])
set(gca,'FontSize', 14)
ylabel('b_{lim} (mm)')
subplot(212)
plot(omega0*60, w/2/pi, 'b-', omega1*60, w/2/pi, 'b-', omega2*60, w/2/pi, 'b-', omega3*60, w/2/pi, 'b-', omega4*60, w/2/pi, 'b-')
axis([0 30000 0 1500])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('f_c (Hz)')
hold on
plot(omega_generic, fro0, 'b-.', omega_generic, fro1, 'b-.', omega_generic, fro2, 'b-.', omega_generic, fro3, 'b-.')
plot(omega_generic, ftooth0, 'r:', omega_generic, ftooth1, 'r:', omega_generic, ftooth2, 'r:', omega_generic, ftooth3, 'r:', omega_generic, ftooth4, 'r:')
plot([16161], [808], 'b^')
