% p_6_8_2.m
% Copyright
% T. Schmitz
% June 1, 2008

clear
close all
clc

% Fourier series approach
% Define modal parameters for x direction
kx1 = 2e7;              % N/m
wnx1 = 800*2*pi;        % rad/s
zetax1 = 0.05;
kx2 = 1.5e7;            % N/m
wnx2 = 1000*2*pi;       % rad/s
zetax2 = 0.03;

% Define parameters for y direction
ky1 = 2e7;              % N/m
wny1 = 800*2*pi;        % rad/s
zetay1 = 0.05;
ky2 = 1.5e7;            % N/m
wny2 = 1000*2*pi;       % rad/s
zetay2 = 0.03;

phis = 0*pi/180;        % rad
phie = 66.4*pi/180;     % rad

% Cutting force coefficients
Ks = 600e6;             % N/m^2
beta = 60;              % deg
Kn = 1/tan(beta*pi/180);
Kt = Ks/sqrt(1 + Kn^2); % N/m^2
Nt = 4;

alphaxx = 0.5*((cos(2*phie)-2*Kn*phie+Kn*sin(2*phie))-(cos(2*phis)-2*Kn*phis+Kn*sin(2*phis)));
alphaxy = 0.5*((-sin(2*phie)-2*phie+Kn*cos(2*phie))-(-sin(2*phis)-2*phis+Kn*cos(2*phis)));
alphayx = 0.5*((-sin(2*phie)+2*phie+Kn*cos(2*phie))-(-sin(2*phis)+2*phis+Kn*cos(2*phis)));
alphayy = 0.5*((-cos(2*phie)-2*Kn*phie-Kn*sin(2*phie))-(-cos(2*phis)-2*Kn*phis-Kn*sin(2*phis)));

wnmax = max([max([wnx1 wnx2]) max([wny1 wny2])]);
w = (0:0.1:2*wnmax/2/pi)'*2*pi;   % frequency, rad/s
FRFxx = (wnx1^2/kx1)./(wnx1^2 - w.^2 + 1i*2*zetax1*wnx1.*w) + (wnx2^2/kx2)./(wnx2^2 - w.^2 + 1i*2*zetax2*wnx2.*w);
FRFyy = (wny1^2/ky1)./(wny1^2 - w.^2 + 1i*2*zetay1*wny1.*w) + (wny2^2/ky2)./(wny2^2 - w.^2 + 1i*2*zetay2*wny2.*w);

for cnt = 1:length(w)
    % Oriented FRF
    FRF_or = [alphaxx*FRFxx(cnt) alphaxy*FRFyy(cnt); alphayx*FRFxx(cnt) alphayy*FRFyy(cnt)];    % m/N
    % Calculate two eigenvalues
    E = eig(FRF_or);
    temp = E(1);
    lambda1(cnt) = temp;
    temp = E(2);
    lambda2(cnt) = temp;
    if (cnt > 1)
        dot_prod1 = real(lambda2(cnt))*real(lambda2(cnt-1)) + imag(lambda2(cnt))*imag(lambda2(cnt-1));
        dot_prod2 = real(lambda2(cnt))*real(lambda1(cnt-1)) + imag(lambda2(cnt))*imag(lambda1(cnt-1));
        if (dot_prod2 > dot_prod1)
            temp = lambda2(cnt);
            lambda2(cnt) = lambda1(cnt);
            lambda1(cnt) = temp;
        end
    end
end

lambda1 = lambda1';
lambda2 = lambda2';

blim1 = (2*pi/Nt/Kt)./((real(lambda1)).^2 + (imag(lambda1)).^2) .* (real(lambda1) .* (1 + (imag(lambda1)./real(lambda1)).^2));  % m
blim2 = (2*pi/Nt/Kt)./((real(lambda2)).^2 + (imag(lambda2)).^2) .* (real(lambda2) .* (1 + (imag(lambda2)./real(lambda2)).^2));

[index1] = find(blim1 > 0);
blim1 = blim1(index1);
blim1 = blim1*1e3;      % mm
w1 = w(index1);
psi1 = atan2(imag(lambda1), real(lambda1));
psi1 = psi1(index1);
epsilon1 = pi - 2*psi1;
omega11 = (60/Nt)*w1./(epsilon1 + 2*0*pi);     % rpm
omega12 = (60/Nt)*w1./(epsilon1 + 2*1*pi);
omega13 = (60/Nt)*w1./(epsilon1 + 2*2*pi);
omega14 = (60/Nt)*w1./(epsilon1 + 2*3*pi);
omega15 = (60/Nt)*w1./(epsilon1 + 2*4*pi);
omega16 = (60/Nt)*w1./(epsilon1 + 2*5*pi);
omega17 = (60/Nt)*w1./(epsilon1 + 2*6*pi);
omega18 = (60/Nt)*w1./(epsilon1 + 2*7*pi);

[index2] = find(blim2 > 0);
blim2 = blim2(index2);
blim2 = blim2*1e3;
w2 = w(index2);
psi2 = atan2(imag(lambda2), real(lambda2));
psi2 = psi2(index2);
epsilon2 = pi - 2*psi2;
omega21 = (60/Nt)*w2./(epsilon2 + 2*0*pi);
omega22 = (60/Nt)*w2./(epsilon2 + 2*1*pi);
omega23 = (60/Nt)*w2./(epsilon2 + 2*2*pi);
omega24 = (60/Nt)*w2./(epsilon2 + 2*3*pi);
omega25 = (60/Nt)*w2./(epsilon2 + 2*4*pi);
omega26 = (60/Nt)*w2./(epsilon2 + 2*5*pi);
omega27 = (60/Nt)*w2./(epsilon2 + 2*6*pi);
omega28 = (60/Nt)*w2./(epsilon2 + 2*7*pi);

figure(1)
% First eigenvalue
plot(omega11, blim1, 'b', omega12, blim1, 'b', omega13, blim1, 'b', omega14, blim1, 'b', omega15, blim1, 'b', omega16, blim1, 'b', omega17, blim1, 'b', omega18, blim1, 'b')
hold on
% Second eigenvalue
plot(omega21, blim2, 'b:', omega22, blim2, 'b:', omega23, blim2, 'b:', omega24, blim2, 'b:', omega25, blim2, 'b:', omega26, blim2, 'b:', omega27, blim2, 'b:', omega28, blim2, 'b:')
axis([1700 15300 0 11])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('b_{lim} (mm)')

% Uniform teeth spacing circular tool path time domain simulation (p_6_3_1_1.m) results
hold on
omega1_s = [2000:500:4500 5000:1000:15000];
b1_s = ones(1, length(omega1_s));
omega2_s = [2000:500:4500 5000:1000:15000];
b2_s = ones(1, length(omega2_s))*2;
omega3_s = [2000:500:4500 5000:1000:15000];
b3_s = ones(1, length(omega3_s))*3;
omega4_s = [2500:500:4500 5000 7000 8000 10000:1000:15000];
b4_s = ones(1, length(omega4_s))*4;
omega5_s = [2500:500:3500 4500 5000 7000 8000 11000:1000:15000];
b5_s = ones(1, length(omega5_s))*5;
omega6_s = [2500:500:3000 5000 7000 8000 11000:1000:15000];
b6_s = ones(1, length(omega6_s))*6;
omega7_s = [3000 5000 7000 8000 12000:1000:15000];
b7_s = ones(1, length(omega7_s))*7;
omega8_s = [5000 7000 12000:1000:15000];
b8_s = ones(1, length(omega8_s))*8;
omega9_s = [5000 7000 12000:1000:15000];
b9_s = ones(1, length(omega9_s))*9;
omega10_s = [5000 7000 12000:1000:15000];
b10_s = ones(1, length(omega10_s))*10;
plot(omega1_s, b1_s, 'bo', omega2_s, b2_s, 'bo', omega3_s, b3_s, 'bo', omega4_s, b4_s, 'bo', omega5_s, b5_s, 'bo')
plot(omega6_s, b6_s, 'bo', omega7_s, b7_s, 'bo', omega8_s, b8_s, 'bo', omega9_s, b9_s, 'bo', omega10_s, b10_s, 'bo')

omega4_u = [2000 6000 9000];
b4_u = ones(1, length(omega4_u))*4;
omega5_u = [2000 4000 6000 9000 10000];
b5_u = ones(1, length(omega5_u))*5;
omega6_u = [2000 3500 4000 4500 6000 9000 10000];
b6_u = ones(1, length(omega6_u))*6;
omega7_u = [2000 2500 3500 4000 4500 6000 9000 10000 11000];
b7_u = ones(1, length(omega7_u))*7;
omega8_u = [2000 2500 3000 3500 4000 4500 6000 8000 9000 10000 11000];
b8_u = ones(1, length(omega8_u))*8;
omega9_u = [2000 2500 3000 3500 4000 4500 6000 8000 9000 10000 11000];
b9_u = ones(1, length(omega9_u))*9;
omega10_u = [2000 2500 3000 3500 4000 4500 6000 8000 9000 10000 11000];
b10_u = ones(1, length(omega10_u))*10;
plot(omega4_u, b4_u, 'rx', omega5_u, b5_u, 'rx')
plot(omega6_u, b6_u, 'rx', omega7_u, b7_u, 'rx', omega8_u, b8_u, 'rx', omega9_u, b9_u, 'rx', omega10_u, b10_u, 'rx')

figure(2)
% First eigenvalue
plot(omega11, blim1, 'b', omega12, blim1, 'b', omega13, blim1, 'b', omega14, blim1, 'b', omega15, blim1, 'b', omega16, blim1, 'b', omega17, blim1, 'b', omega18, blim1, 'b')
hold on
% Second eigenvalue
plot(omega21, blim2, 'b:', omega22, blim2, 'b:', omega23, blim2, 'b:', omega24, blim2, 'b:', omega25, blim2, 'b:', omega26, blim2, 'b:', omega27, blim2, 'b:', omega28, blim2, 'b:')
axis([1700 15300 0 11])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('b_{lim} (mm)')

% Variable teeth spacing circular tool path time domain simulation
% (p_6_3_1_1.m) results -- {0 95 180 275} deg
hold on
omega1_s = [2000:500:4500 5000:1000:15000];
b1_s = ones(1, length(omega1_s));
omega2_s = [2000:500:4500 5000:1000:15000];
b2_s = ones(1, length(omega2_s))*2;
omega3_s = [2000:500:4500 5000:1000:15000];
b3_s = ones(1, length(omega3_s))*3;
omega4_s = [2000:500:4500 5000:1000:15000];
b4_s = ones(1, length(omega4_s))*4;
omega5_s = [2000 3000:500:5000 6000 7000 8000 10000:1000:15000];
b5_s = ones(1, length(omega5_s))*5;
omega6_s = [3000:500:5000 6000 7000 8000 11000:1000:15000];
b6_s = ones(1, length(omega6_s))*6;
omega7_s = [3000:500:5000 7000 8000 11000:1000:15000];
b7_s = ones(1, length(omega7_s))*7;
omega8_s = [3500:500:5000 7000 8000 11000:1000:15000];
b8_s = ones(1, length(omega8_s))*8;
omega9_s = [3500:500:5000 7000 8000 11000:1000:15000];
b9_s = ones(1, length(omega9_s))*9;
omega10_s = [3500 5000 7000 11000:1000:15000];
b10_s = ones(1, length(omega10_s))*10;
plot(omega1_s, b1_s, 'bo', omega2_s, b2_s, 'bo', omega3_s, b3_s, 'bo', omega4_s, b4_s, 'bo', omega5_s, b5_s, 'bo')
plot(omega6_s, b6_s, 'bo', omega7_s, b7_s, 'bo', omega8_s, b8_s, 'bo', omega9_s, b9_s, 'bo', omega10_s, b10_s, 'bo')

omega5_u = [2500 9000];
b5_u = ones(1, length(omega5_u))*5;
omega6_u = [2000 2500 9000 10000];
b6_u = ones(1, length(omega6_u))*6;
omega7_u = [2000 2500 6000 9000 10000];
b7_u = ones(1, length(omega7_u))*7;
omega8_u = [2000 2500 3000 6000 9000 10000];
b8_u = ones(1, length(omega8_u))*8;
omega9_u = [2000 2500 3000 6000 9000 10000];
b9_u = ones(1, length(omega9_u))*9;
omega10_u = [2000 2500 3000 4000 4500 6000 8000 9000 10000];
b10_u = ones(1, length(omega10_u))*10;
plot(omega5_u, b5_u, 'rx')
plot(omega6_u, b6_u, 'rx', omega7_u, b7_u, 'rx', omega8_u, b8_u, 'rx', omega9_u, b9_u, 'rx', omega10_u, b10_u, 'rx')
