% p_6_9_2.m
% Copyright
% T. Schmitz
% June 1, 2008

clear
close all
clc

% Fourier series approach
% Define modal parameters for x direction
kx1 = 4.1e5;            % N/m
wnx1 = 720*2*pi;        % rad/s
zetax1 = 0.009;

% Define parameters for y direction
ky1 = 4.1e5;            % N/m
wny1 = 720*2*pi;        % rad/s
zetay1 = 0.009;

phis = 0*pi/180;        % rad
phie = 25.8*pi/180;     % rad

% Cutting force coefficients
Kn = 0.37;
Kt = 644e6;             % N/m^2
Nt = 1;

alphaxx = 0.5*((cos(2*phie)-2*Kn*phie+Kn*sin(2*phie))-(cos(2*phis)-2*Kn*phis+Kn*sin(2*phis)));
alphaxy = 0.5*((-sin(2*phie)-2*phie+Kn*cos(2*phie))-(-sin(2*phis)-2*phis+Kn*cos(2*phis)));
alphayx = 0.5*((-sin(2*phie)+2*phie+Kn*cos(2*phie))-(-sin(2*phis)+2*phis+Kn*cos(2*phis)));
alphayy = 0.5*((-cos(2*phie)-2*Kn*phie-Kn*sin(2*phie))-(-cos(2*phis)-2*Kn*phis-Kn*sin(2*phis)));

wnmax = max([wnx1 wny1]);
w = (0:0.1:2*wnmax/2/pi)'*2*pi;   % frequency, rad/s
FRFxx = (wnx1^2/kx1)./(wnx1^2 - w.^2 + 1i*2*zetax1*wnx1.*w);
FRFyy = (wny1^2/ky1)./(wny1^2 - w.^2 + 1i*2*zetay1*wny1.*w);

for cnt = 1:length(w)
    % Oriented FRF
    FRF_or = [alphaxx*FRFxx(cnt) alphaxy*FRFyy(cnt); alphayx*FRFxx(cnt) alphayy*FRFyy(cnt)];    % m/N
    % Calculate two eigenvalues
    E = eig(FRF_or);
    temp = E(1);
    lambda1(cnt) = temp;
    temp = E(2);
    lambda2(cnt) = temp;
end

lambda1 = lambda1';
lambda2 = lambda2';

blim1 = (2*pi/Nt/Kt)./((real(lambda1)).^2 + (imag(lambda1)).^2) .* (real(lambda1) .* (1 + (imag(lambda1)./real(lambda1)).^2));  % m
blim2 = (2*pi/Nt/Kt)./((real(lambda2)).^2 + (imag(lambda2)).^2) .* (real(lambda2) .* (1 + (imag(lambda2)./real(lambda2)).^2));

[index1] = find(blim1 > 0);
blim1 = blim1(index1);
blim1 = blim1*1e3;      % mm
w1 = w(index1);
psi1 = atan2(imag(lambda1), real(lambda1));
psi1 = psi1(index1);
epsilon1 = pi - 2*psi1;
omega11 = (60/Nt)*w1./(epsilon1 + 2*0*pi);     % rpm
omega12 = (60/Nt)*w1./(epsilon1 + 2*1*pi);
omega13 = (60/Nt)*w1./(epsilon1 + 2*2*pi);
omega14 = (60/Nt)*w1./(epsilon1 + 2*3*pi);
omega15 = (60/Nt)*w1./(epsilon1 + 2*4*pi);
omega16 = (60/Nt)*w1./(epsilon1 + 2*5*pi);
omega17 = (60/Nt)*w1./(epsilon1 + 2*6*pi);
omega18 = (60/Nt)*w1./(epsilon1 + 2*7*pi);

[index2] = find(blim2 > 0);
blim2 = blim2(index2);
blim2 = blim2*1e3;
w2 = w(index2);
psi2 = atan2(imag(lambda2), real(lambda2));
psi2 = psi2(index2);
epsilon2 = pi - 2*psi2;
omega21 = (60/Nt)*w2./(epsilon2 + 2*0*pi);
omega22 = (60/Nt)*w2./(epsilon2 + 2*1*pi);
omega23 = (60/Nt)*w2./(epsilon2 + 2*2*pi);
omega24 = (60/Nt)*w2./(epsilon2 + 2*3*pi);
omega25 = (60/Nt)*w2./(epsilon2 + 2*4*pi);
omega26 = (60/Nt)*w2./(epsilon2 + 2*5*pi);
omega27 = (60/Nt)*w2./(epsilon2 + 2*6*pi);
omega28 = (60/Nt)*w2./(epsilon2 + 2*7*pi);

figure(1)
% First eigenvalue
plot(omega11, blim1, 'b', omega12, blim1, 'b', omega13, blim1, 'b', omega14, blim1, 'b', omega15, blim1, 'b', omega16, blim1, 'b', omega17, blim1, 'b', omega18, blim1, 'b')
hold on
% Second eigenvalue
plot(omega21, blim2, 'b:', omega22, blim2, 'b:', omega23, blim2, 'b:', omega24, blim2, 'b:', omega25, blim2, 'b:', omega26, blim2, 'b:', omega27, blim2, 'b:', omega28, blim2, 'b:')
axis([23000 35000 0 2.4])
set(gca,'FontSize', 14)
xlabel('\Omega (rpm)')
ylabel('b_{lim} (mm)')

% Time domain simulation (p_6_4_1_1.m) results
hold on
omega1_s = [24000:1000:34000];
b1_s = ones(1, length(omega1_s))*0.2;
omega2_s = [24000:1000:28000 30000:1000:34000];
b2_s = ones(1, length(omega2_s))*0.4;
omega3_s = [26000:1000:28000 30000:1000:34000];
b3_s = ones(1, length(omega3_s))*0.6;
omega4_s = [27000:1000:28000 31000:1000:34000];
b4_s = ones(1, length(omega4_s))*0.8;
omega5_s = [27000:1000:28000 31000:1000:34000];
b5_s = ones(1, length(omega5_s))*1;
omega6_s = [28000 31000:1000:34000];
b6_s = ones(1, length(omega6_s))*1.2;
omega7_s = [28000 32000:1000:34000];
b7_s = ones(1, length(omega7_s))*1.4;
omega8_s = [28000 32000:1000:34000];
b8_s = ones(1, length(omega8_s))*1.6;
omega9_s = [28000 32000:1000:34000];
b9_s = ones(1, length(omega9_s))*1.8;
omega10_s = [32000:1000:34000];
b10_s = ones(1, length(omega10_s))*2;
omega11_s = [33000:1000:34000];
b11_s = ones(1, length(omega11_s))*2.2;
plot(omega1_s, b1_s, 'bo', omega2_s, b2_s, 'bo', omega3_s, b3_s, 'bo', omega4_s, b4_s, 'bo', omega5_s, b5_s, 'bo')
plot(omega6_s, b6_s, 'bo', omega7_s, b7_s, 'bo', omega8_s, b8_s, 'bo', omega9_s, b9_s, 'bo', omega10_s, b10_s, 'bo', omega11_s, b11_s, 'bo')

% secondary Hopf
omega3_u = [24000:1000:25000];
b3_u = ones(1, length(omega3_u))*0.6;
omega4_u = [24000:1000:26000];
b4_u = ones(1, length(omega4_u))*0.8;
omega5_u = [24000:1000:26000];
b5_u = ones(1, length(omega5_u))*1;
omega6_u = [24000:1000:27000];
b6_u = ones(1, length(omega6_u))*1.2;
omega7_u = [24000:1000:27000];
b7_u = ones(1, length(omega7_u))*1.4;
omega8_u = [24000:1000:27000];
b8_u = ones(1, length(omega8_u))*1.6;
omega9_u = [24000:1000:27000];
b9_u = ones(1, length(omega9_u))*1.8;
omega10_u = [24000:1000:28000];
b10_u = ones(1, length(omega10_u))*2;
omega11_u = [24000:1000:28000];
b11_u = ones(1, length(omega11_u))*2.2;

plot(omega3_u, b3_u, 'rx', omega4_u, b4_u, 'rx', omega5_u, b5_u, 'rx')
plot(omega6_u, b6_u, 'rx', omega7_u, b7_u, 'rx', omega8_u, b8_u, 'rx', omega9_u, b9_u, 'rx', omega10_u, b10_u, 'rx', omega11_u, b11_u, 'rx')

% period-2
omega2_u = [29000];
b2_u = ones(1, length(omega2_u))*0.4;
omega3_u = [29000];
b3_u = ones(1, length(omega3_u))*0.6;
omega4_u = [29000:1000:30000];
b4_u = ones(1, length(omega4_u))*0.8;
omega5_u = [29000:1000:30000];
b5_u = ones(1, length(omega5_u))*1;
omega6_u = [29000:1000:30000];
b6_u = ones(1, length(omega6_u))*1.2;
omega7_u = [29000:1000:31000];
b7_u = ones(1, length(omega7_u))*1.4;
omega8_u = [29000:1000:31000];
b8_u = ones(1, length(omega8_u))*1.6;
omega9_u = [29000:1000:31000];
b9_u = ones(1, length(omega9_u))*1.8;
omega10_u = [29000:1000:31000];
b10_u = ones(1, length(omega10_u))*2;
omega11_u = [29000:1000:32000];
b11_u = ones(1, length(omega11_u))*2.2;

plot(omega2_u, b2_u, 'k^', omega3_u, b3_u, 'k^', omega4_u, b4_u, 'k^', omega5_u, b5_u, 'k^')
plot(omega6_u, b6_u, 'k^', omega7_u, b7_u, 'k^', omega8_u, b8_u, 'k^', omega9_u, b9_u, 'k^', omega10_u, b10_u, 'k^', omega11_u, b11_u, 'k^')
